/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.jsr107.tck.event.TestCacheEntryEvent;
import org.jsr107.tck.support.OperationHandler;
import org.jsr107.tck.support.Server;

public class CacheEntryListenerServer<K, V>
extends Server {
    private Set<CacheEntryListener<K, V>> listeners = new HashSet<CacheEntryListener<K, V>>();

    public CacheEntryListenerServer(int port, Class keyClass, Class valueClass) {
        super(port);
        for (EventType eventType : EventType.values()) {
            this.addOperationHandler(new CacheEntryEventOperationHandler(eventType, keyClass, valueClass));
        }
    }

    public void addCacheEventListener(CacheEntryListener<K, V> cacheEventListener) {
        if (cacheEventListener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(cacheEventListener);
    }

    public void removeCacheEventListener(CacheEntryListener<K, V> cacheEventListener) {
        if (cacheEventListener != null) {
            this.listeners.remove(cacheEventListener);
        }
    }

    private void runHandlers(EventType eventType, TestCacheEntryEvent event) {
        ArrayList<TestCacheEntryEvent> events = new ArrayList<TestCacheEntryEvent>(1);
        events.add(event);
        for (CacheEntryListener<K, V> listener : this.listeners) {
            switch (eventType) {
                case CREATED: {
                    if (!(listener instanceof CacheEntryCreatedListener)) break;
                    ((CacheEntryCreatedListener)listener).onCreated(events);
                    break;
                }
                case UPDATED: {
                    if (!(listener instanceof CacheEntryUpdatedListener)) break;
                    ((CacheEntryUpdatedListener)listener).onUpdated(events);
                    break;
                }
                case REMOVED: {
                    if (!(listener instanceof CacheEntryRemovedListener)) break;
                    ((CacheEntryRemovedListener)listener).onRemoved(events);
                    break;
                }
                case EXPIRED: {
                    if (!(listener instanceof CacheEntryExpiredListener)) break;
                    ((CacheEntryExpiredListener)listener).onExpired(events);
                    break;
                }
            }
        }
    }

    public class CacheEntryEventOperationHandler
    implements OperationHandler {
        private EventType eventType;
        private Class keyClass;
        private Class valueClass;

        public CacheEntryEventOperationHandler(EventType type, Class keyClass, Class valueClass) {
            this.eventType = type;
            this.keyClass = keyClass;
            this.valueClass = valueClass;
        }

        @Override
        public String getType() {
            return this.eventType.name();
        }

        @Override
        public void onProcess(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            String sourceCacheName = ois.readUTF();
            URI sourceCacheManagerURI = (URI)ois.readObject();
            Cache source = null;
            try {
                source = Caching.getCachingProvider().getCacheManager(sourceCacheManagerURI, null).getCache(sourceCacheName, this.keyClass, this.valueClass);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                TestCacheEntryEvent event = new TestCacheEntryEvent(source, this.eventType);
                event.readObject(ois);
                CacheEntryListenerServer.this.runHandlers(this.eventType, event);
                oos.writeObject(null);
            }
            catch (Throwable t) {
                oos.writeObject(t);
            }
        }
    }
}

