/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.configuration;

import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsr107.tck.integration.FailingCacheLoader;
import org.jsr107.tck.integration.FailingCacheWriter;
import org.jsr107.tck.integration.NullValueCacheLoader;
import org.jsr107.tck.integration.RecordingCacheWriter;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class MutableConfigurationTest
extends CacheTestSupport {
    private void validateDefaults(CompleteConfiguration<?, ?> config) {
        Assert.assertEquals(Object.class, (Object)config.getKeyType());
        Assert.assertEquals(Object.class, (Object)config.getValueType());
        Assert.assertFalse((boolean)config.isReadThrough());
        Assert.assertFalse((boolean)config.isWriteThrough());
        Assert.assertTrue((boolean)config.isStoreByValue());
        Assert.assertFalse((boolean)config.isStatisticsEnabled());
        Assert.assertFalse((boolean)config.isManagementEnabled());
        Assert.assertTrue((this.getConfigurationCacheEntryListenerConfigurationSize(config) == 0 ? 1 : 0) != 0);
        junit.framework.Assert.assertNull((Object)config.getCacheLoaderFactory());
        junit.framework.Assert.assertNull((Object)config.getCacheWriterFactory());
        config.hashCode();
        ExpiryPolicy expiryPolicy = (ExpiryPolicy)config.getExpiryPolicyFactory().create();
        Assert.assertTrue((boolean)(expiryPolicy instanceof EternalExpiryPolicy));
        Assert.assertThat((Object)Duration.ETERNAL, (Matcher)CoreMatchers.equalTo((Object)expiryPolicy.getExpiryForCreation()));
        Assert.assertThat((Object)expiryPolicy.getExpiryForAccess(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)expiryPolicy.getExpiryForUpdate(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testDefaultCacheFromCacheManagerUsesCorrectDefaults() {
        Cache cache = this.getCacheManager().getCache(this.getTestCacheName());
        CompleteConfiguration configuration = (CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class);
        this.validateDefaults(configuration);
    }

    @Test
    public void testModifyingConfigurationAfterCreateCacheDoesNotModifyCacheConfiguration() {
        MutableConfiguration mutableConfiguration = new MutableConfiguration().setTypes(Integer.class, Integer.class);
        Cache cache = this.getCacheManager().createCache(this.getTestCacheName() + "_", (Configuration)mutableConfiguration);
        mutableConfiguration.setTypes(String.class, String.class);
        Assert.assertEquals(Integer.class, (Object)((CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class)).getKeyType());
        Assert.assertEquals(Integer.class, (Object)((CompleteConfiguration)cache.getConfiguration(CompleteConfiguration.class)).getValueType());
    }

    @Test
    public void testNewMutableConfigurationUsesCorrectDefaults() {
        MutableConfiguration config = new MutableConfiguration();
        this.validateDefaults((CompleteConfiguration)config);
    }

    @Test
    public void shouldBeEqualWhenUsingDefaults() {
        MutableConfiguration config1 = new MutableConfiguration();
        MutableConfiguration config2 = new MutableConfiguration();
        Assert.assertEquals((Object)config1, (Object)config2);
    }

    @Test
    public void shouldBeEqualWhenUsingTypedAndUntypedConfigurationsWithObject() {
        MutableConfiguration config1 = new MutableConfiguration();
        MutableConfiguration config2 = new MutableConfiguration().setTypes(Object.class, Object.class);
        Assert.assertThat((Object)config1.equals(config2), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldNotBeTheSameButAClone() {
        MutableConfiguration config1 = new MutableConfiguration((CompleteConfiguration)new MutableConfiguration());
        MutableConfiguration config2 = new MutableConfiguration();
        Assert.assertNotSame((Object)config1, (Object)config2);
        Assert.assertEquals((Object)config1, (Object)config2);
    }

    @Test
    public void shouldNotBeTheSame() {
        MutableConfiguration config1 = new MutableConfiguration();
        MutableConfiguration config2 = new MutableConfiguration();
        Assert.assertNotSame((Object)config1, (Object)config2);
    }

    @Test
    public void shouldEqual() {
        MutableConfiguration config1 = new MutableConfiguration();
        MutableConfiguration config2 = new MutableConfiguration();
        Assert.assertEquals((Object)config1, (Object)config2);
    }

    @Test
    public void testCopyConstructor() {
        MutableConfiguration<String, String> copyConfig = new MutableConfiguration<String, String>(){

            public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
                return null;
            }
        };
        copyConfig.hashCode();
        Assert.assertNull((Object)copyConfig.getExpiryPolicyFactory());
        MutableConfiguration config = new MutableConfiguration((CompleteConfiguration)copyConfig);
        Assert.assertNotNull((Object)config.getExpiryPolicyFactory());
    }

    @Test
    public void testSetAttributeToNull() {
        MutableConfiguration config = new MutableConfiguration();
        try {
            config.setTypes(null, String.class);
            Assert.fail((String)"null poiner exception expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            config.setTypes(String.class, null);
            Assert.fail((String)"null poiner exception expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            config.addCacheEntryListenerConfiguration(null);
            Assert.fail((String)"null poiner exception expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            config.setExpiryPolicyFactory(null);
            Assert.assertNotNull((Object)config.getExpiryPolicyFactory());
        }
        catch (NullPointerException e) {
            Assert.fail((String)"should not throw NullPointerException when setting ExpiryPolicyFactory to null");
        }
    }

    @Test
    public void testEqualsHashCode() {
        MutableConfiguration config1 = new MutableConfiguration();
        config1.setTypes(String.class, String.class);
        config1.hashCode();
        Assert.assertTrue((boolean)config1.equals((Object)config1));
        Assert.assertFalse((boolean)config1.equals(null));
        Assert.assertFalse((boolean)config1.equals((Object)"NonMutableConfigurationCompareForCodeCoverage"));
        MutableConfiguration config2 = new MutableConfiguration();
        config2.setTypes(Integer.class, String.class);
        Assert.assertFalse((boolean)config1.equals((Object)config2));
        MutableConfiguration config3 = new MutableConfiguration();
        config3.setTypes(String.class, Integer.class);
        Assert.assertFalse((boolean)config1.equals((Object)config3));
        MutableConfiguration differentConfig1 = new MutableConfiguration((CompleteConfiguration)config1);
        differentConfig1.setStatisticsEnabled(!config1.isStatisticsEnabled());
        differentConfig1.hashCode();
        config1.hashCode();
        Assert.assertFalse((boolean)config1.equals((Object)differentConfig1));
        differentConfig1 = new MutableConfiguration((CompleteConfiguration)config1);
        differentConfig1.setStoreByValue(!config1.isStoreByValue());
        differentConfig1.hashCode();
        Assert.assertFalse((boolean)config1.equals((Object)differentConfig1));
        differentConfig1 = new MutableConfiguration((CompleteConfiguration)config1);
        differentConfig1.setReadThrough(!config1.isReadThrough());
        differentConfig1.hashCode();
        Assert.assertFalse((boolean)config1.equals((Object)differentConfig1));
        differentConfig1 = new MutableConfiguration((CompleteConfiguration)config1);
        differentConfig1.setWriteThrough(!config1.isWriteThrough());
        differentConfig1.hashCode();
        Assert.assertFalse((boolean)config1.equals((Object)differentConfig1));
        differentConfig1 = new MutableConfiguration((CompleteConfiguration)config1);
        differentConfig1.setExpiryPolicyFactory(TouchedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, 20L)));
        Assert.assertFalse((boolean)config1.equals((Object)differentConfig1));
        MutableConfiguration rawConfig1 = new MutableConfiguration();
        MutableConfiguration rawConfig2 = new MutableConfiguration((CompleteConfiguration)rawConfig1);
        rawConfig2.setCacheLoaderFactory(FactoryBuilder.factoryOf(NullValueCacheLoader.class));
        Assert.assertFalse((boolean)rawConfig1.equals((Object)rawConfig2));
        Assert.assertFalse((boolean)rawConfig2.equals((Object)rawConfig1));
        rawConfig1.setCacheLoaderFactory(rawConfig2.getCacheLoaderFactory());
        rawConfig1.hashCode();
        Assert.assertEquals((Object)rawConfig1, (Object)rawConfig2);
        rawConfig2.setCacheLoaderFactory(FactoryBuilder.factoryOf(FailingCacheLoader.class));
        Assert.assertFalse((boolean)rawConfig2.equals((Object)rawConfig1));
        Assert.assertFalse((boolean)rawConfig1.equals((Object)rawConfig2));
        rawConfig1 = new MutableConfiguration();
        rawConfig2 = new MutableConfiguration((CompleteConfiguration)rawConfig1);
        rawConfig2.setCacheWriterFactory(FactoryBuilder.factoryOf(RecordingCacheWriter.class));
        rawConfig2.hashCode();
        Assert.assertFalse((boolean)rawConfig1.equals((Object)rawConfig2));
        Assert.assertFalse((boolean)rawConfig2.equals((Object)rawConfig1));
        rawConfig1.setCacheWriterFactory(rawConfig2.getCacheWriterFactory());
        Assert.assertEquals((Object)rawConfig1, (Object)rawConfig2);
        rawConfig2.setCacheWriterFactory(FactoryBuilder.factoryOf(FailingCacheWriter.class));
        rawConfig2.hashCode();
        Assert.assertFalse((boolean)rawConfig2.equals((Object)rawConfig1));
        Assert.assertFalse((boolean)rawConfig1.equals((Object)rawConfig2));
        rawConfig1 = new MutableConfiguration<String, String>(){

            public MutableConfiguration<String, String> setExpiryPolicyFactory(Factory<? extends ExpiryPolicy> factory) {
                this.expiryPolicyFactory = null;
                return this;
            }
        };
        rawConfig2 = new MutableConfiguration((CompleteConfiguration)rawConfig1);
        rawConfig1.setExpiryPolicyFactory(null);
        rawConfig1.hashCode();
        Assert.assertFalse((boolean)rawConfig1.equals((Object)rawConfig2));
        rawConfig2 = new MutableConfiguration<String, String>(){

            public MutableConfiguration<String, String> setExpiryPolicyFactory(Factory<? extends ExpiryPolicy> factory) {
                this.expiryPolicyFactory = null;
                return this;
            }
        };
        rawConfig2.setExpiryPolicyFactory(null);
        Assert.assertTrue((boolean)rawConfig1.equals((Object)rawConfig2));
        MutableCacheEntryListenerConfiguration listenerConfig1 = new MutableCacheEntryListenerConfiguration(null, null, false, false);
        MutableCacheEntryListenerConfiguration listenerConfig2 = new MutableCacheEntryListenerConfiguration(null, null, true, false);
        rawConfig1 = new MutableConfiguration();
        rawConfig2 = new MutableConfiguration((CompleteConfiguration)rawConfig1);
        rawConfig1.hashCode();
        rawConfig2.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)new MutableCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)listenerConfig2));
        rawConfig2.hashCode();
        Assert.assertFalse((boolean)rawConfig1.equals((Object)rawConfig2));
        Assert.assertFalse((boolean)rawConfig2.equals((Object)rawConfig1));
        rawConfig1.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)listenerConfig1);
        Assert.assertFalse((boolean)rawConfig1.equals((Object)rawConfig2));
        Assert.assertFalse((boolean)rawConfig2.equals((Object)rawConfig1));
        MutableConfiguration rawConfig3 = new MutableConfiguration((CompleteConfiguration)rawConfig1);
        Assert.assertTrue((boolean)rawConfig3.equals((Object)rawConfig1));
    }

    protected MutableConfiguration newMutableConfiguration() {
        return new MutableConfiguration();
    }

    private int getConfigurationCacheEntryListenerConfigurationSize(CompleteConfiguration config) {
        int i = 0;
        for (Object listenerConfig : config.getCacheEntryListenerConfigurations()) {
            ++i;
        }
        return i;
    }
}

