/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.cache.Cache;
import javax.cache.integration.CacheWriter;
import org.jsr107.tck.support.CacheClient;
import org.jsr107.tck.support.Operation;

public class CacheWriterClient<K, V>
extends CacheClient
implements CacheWriter<K, V> {
    public CacheWriterClient(InetAddress address, int port) {
        super(address, port);
    }

    public void write(Cache.Entry<? extends K, ? extends V> entry) {
        this.getClient().invoke(new WriteOperation<K, V>(entry));
    }

    public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> entries) {
        this.getClient().invoke(new WriteAllOperation<K, V>(entries));
    }

    public void delete(Object key) {
        this.getClient().invoke(new DeleteOperation(key));
    }

    public void deleteAll(Collection<?> keys) {
        this.getClient().invoke(new DeleteAllOperation(keys));
    }

    private static class WriteOperation<K, V>
    implements Operation<V> {
        private Cache.Entry<? extends K, ? extends V> entry;

        public WriteOperation(Cache.Entry<? extends K, ? extends V> entry) {
            this.entry = entry;
        }

        @Override
        public String getType() {
            return "write";
        }

        @Override
        public V onInvoke(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            oos.writeObject(this.entry.getKey());
            oos.writeObject(this.entry.getValue());
            Object o = ois.readObject();
            if (o instanceof RuntimeException) {
                throw (RuntimeException)o;
            }
            return null;
        }
    }

    private static class WriteAllOperation<K, V>
    implements Operation<Map<K, V>> {
        private Collection<Cache.Entry<? extends K, ? extends V>> entries;

        public WriteAllOperation(Collection<Cache.Entry<? extends K, ? extends V>> entries) {
            this.entries = entries;
        }

        @Override
        public String getType() {
            return "writeAll";
        }

        @Override
        public Map<K, V> onInvoke(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            for (Cache.Entry<? extends K, ? extends V> entry : this.entries) {
                oos.writeObject(entry.getKey());
                oos.writeObject(entry.getValue());
            }
            oos.writeObject(null);
            Object o = ois.readObject();
            if (o instanceof RuntimeException) {
                HashSet<Object> hashSet = new HashSet<Object>();
                Object key = ois.readObject();
                while (key != null) {
                    hashSet.add(key);
                    key = ois.readObject();
                }
                Iterator<Cache.Entry<K, V>> iter = this.entries.iterator();
                while (iter.hasNext()) {
                    if (hashSet.contains(iter.next().getKey())) continue;
                    iter.remove();
                }
                throw (RuntimeException)o;
            }
            this.entries.clear();
            return null;
        }
    }

    private static class DeleteOperation<K, V>
    implements Operation<V> {
        private K key;

        public DeleteOperation(K key) {
            this.key = key;
        }

        @Override
        public String getType() {
            return "delete";
        }

        @Override
        public V onInvoke(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            oos.writeObject(this.key);
            Object o = ois.readObject();
            if (o instanceof RuntimeException) {
                throw (RuntimeException)o;
            }
            return null;
        }
    }

    private static class DeleteAllOperation<K, V>
    implements Operation<Map<K, V>> {
        private Collection<? extends K> keys;

        public DeleteAllOperation(Collection<? extends K> keys) {
            this.keys = keys;
        }

        @Override
        public String getType() {
            return "deleteAll";
        }

        @Override
        public Map<K, V> onInvoke(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException, ExecutionException {
            for (K key : this.keys) {
                oos.writeObject(key);
            }
            oos.writeObject(null);
            Object result = ois.readObject();
            if (result instanceof RuntimeException) {
                Collection notDeletedKeys = (Collection)ois.readObject();
                Iterator<K> iter = this.keys.iterator();
                while (iter.hasNext()) {
                    if (notDeletedKeys.contains(iter.next())) continue;
                    iter.remove();
                }
                throw (RuntimeException)result;
            }
            this.keys.clear();
            return null;
        }
    }
}

