/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.configuration;

import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import org.junit.Assert;
import org.junit.Test;

public class MutableCacheEntryListenerConfigurationTest {
    @Test
    public void testCopyConstructor() {
        MutableCacheEntryListenerConfiguration config = new MutableCacheEntryListenerConfiguration(null, null, true, true);
        MutableCacheEntryListenerConfiguration copyConfig = new MutableCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)config);
        Assert.assertTrue((boolean)config.equals((Object)copyConfig));
        junit.framework.Assert.assertFalse((boolean)config.equals((Object)new String("notEqualDifferentClassPath")));
    }

    @Test
    public void testEqualsHashCode() {
        MutableCacheEntryListenerConfiguration config1 = new MutableCacheEntryListenerConfiguration(null, null, false, false);
        MutableCacheEntryListenerConfiguration config2 = new MutableCacheEntryListenerConfiguration(null, null, true, false);
        MutableCacheEntryListenerConfiguration config3 = new MutableCacheEntryListenerConfiguration(null, null, false, true);
        MutableCacheEntryListenerConfiguration config4 = new MutableCacheEntryListenerConfiguration(null, null, true, true);
        junit.framework.Assert.assertFalse((boolean)config1.equals((Object)config2));
        junit.framework.Assert.assertFalse((boolean)config1.equals((Object)config3));
        junit.framework.Assert.assertFalse((boolean)config1.equals((Object)config4));
        junit.framework.Assert.assertFalse((boolean)config1.equals(null));
        config1.hashCode();
        config2.hashCode();
        config3.hashCode();
        config4.hashCode();
        config1.setSynchronous(config2.isSynchronous());
        config1.setOldValueRequired(config2.isOldValueRequired());
        Assert.assertTrue((boolean)config1.equals((Object)config2));
        config1.setCacheEntryEventFilterFactory(config2.getCacheEntryEventFilterFactory());
        config1.setCacheEntryListenerFactory(config2.getCacheEntryListenerFactory());
        Factory listenerFactory1 = FactoryBuilder.factoryOf(ACacheEntryListener.class);
        Factory listenerFactory2 = FactoryBuilder.factoryOf(AnotherCacheEntryListener.class);
        config1.setCacheEntryListenerFactory(listenerFactory1);
        junit.framework.Assert.assertFalse((boolean)config2.equals((Object)config1));
        config2.setCacheEntryListenerFactory(listenerFactory1);
        Assert.assertTrue((boolean)config1.equals((Object)config2));
        config1.hashCode();
        config2.setCacheEntryListenerFactory(listenerFactory2);
        junit.framework.Assert.assertFalse((boolean)config1.equals((Object)config2));
        config2.setCacheEntryListenerFactory(listenerFactory1);
        Factory filterFactory1 = FactoryBuilder.factoryOf(ACacheEntryEventFilter.class);
        Factory filterFactory2 = FactoryBuilder.factoryOf(AnotherCacheEntryEventFilter.class);
        config1.setCacheEntryEventFilterFactory(filterFactory1);
        config2.setCacheEntryEventFilterFactory(filterFactory1);
        Assert.assertTrue((boolean)config1.equals((Object)config2));
        config2.setCacheEntryEventFilterFactory(filterFactory2);
        junit.framework.Assert.assertFalse((boolean)config1.equals((Object)config2));
        config1.hashCode();
    }

    public void testMultipleCacheEntryListenerFactories_differentOrder_shouldbe_equal() {
        Factory listenerFactory1 = FactoryBuilder.factoryOf(ACacheEntryListener.class);
        Factory listenerFactory2 = FactoryBuilder.factoryOf(AnotherCacheEntryListener.class);
        MutableCacheEntryListenerConfiguration listenerConfig1 = new MutableCacheEntryListenerConfiguration(listenerFactory1, null, false, false);
        MutableCacheEntryListenerConfiguration listenerConfig2 = new MutableCacheEntryListenerConfiguration(listenerFactory2, null, false, false);
        MutableConfiguration config1 = new MutableConfiguration();
        MutableConfiguration config2 = new MutableConfiguration();
        config1.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)listenerConfig1);
        config2.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)listenerConfig2);
        junit.framework.Assert.assertFalse((boolean)config1.equals((Object)config2));
        config1.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)listenerConfig2);
        config2.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration)listenerConfig1);
        System.out.println("config1.hashCode=" + config1.hashCode() + " config2.hashcode()=" + config2.hashCode() + "equals()=" + config1.equals((Object)config2));
        Assert.assertTrue((boolean)config1.equals((Object)config2));
    }

    public static class AnotherCacheEntryEventFilter
    implements CacheEntryEventFilter<String, String> {
        public boolean evaluate(CacheEntryEvent<? extends String, ? extends String> event) throws CacheEntryListenerException {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class ACacheEntryEventFilter
    implements CacheEntryEventFilter<String, String> {
        public boolean evaluate(CacheEntryEvent<? extends String, ? extends String> event) throws CacheEntryListenerException {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public static class AnotherCacheEntryListener
    implements CacheEntryListener<String, String> {
    }

    public static class ACacheEntryListener
    implements CacheEntryListener<String, String> {
    }
}

