/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsr107.tck.integration.CacheLoaderClient;
import org.jsr107.tck.integration.CacheLoaderServer;
import org.jsr107.tck.integration.FailingCacheLoader;
import org.jsr107.tck.integration.NullValueCacheLoader;
import org.jsr107.tck.integration.RecordingCacheLoader;
import org.junit.Assert;
import org.junit.Test;

public class CacheLoaderClientServerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLoadFromServerWithClient() {
        RecordingCacheLoader<String> recordingCacheLoader = new RecordingCacheLoader<String>();
        try (CacheLoaderServer serverCacheLoader = new CacheLoaderServer(10000, recordingCacheLoader);){
            serverCacheLoader.open();
            CacheLoaderClient clientCacheLoader = new CacheLoaderClient(serverCacheLoader.getInetAddress(), serverCacheLoader.getPort());
            String value = (String)clientCacheLoader.load("gudday");
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"gudday"));
            Assert.assertThat((Object)recordingCacheLoader.hasLoaded("gudday"), (Matcher)CoreMatchers.is((Object)true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldRethrowExceptions() {
        FailingCacheLoader failingCacheLoader = new FailingCacheLoader();
        try (CacheLoaderServer serverCacheLoader = new CacheLoaderServer(10000, failingCacheLoader);){
            serverCacheLoader.open();
            CacheLoaderClient clientCacheLoader = new CacheLoaderClient(serverCacheLoader.getInetAddress(), serverCacheLoader.getPort());
            String value = (String)clientCacheLoader.load("gudday");
            Assert.fail((String)"An UnsupportedOperationException should have been thrown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLoadNullValuesFromServerWithClient() {
        NullValueCacheLoader nullCacheLoader = new NullValueCacheLoader();
        try (CacheLoaderServer serverCacheLoader = new CacheLoaderServer(10000, nullCacheLoader);){
            serverCacheLoader.open();
            CacheLoaderClient clientCacheLoader = new CacheLoaderClient(serverCacheLoader.getInetAddress(), serverCacheLoader.getPort());
            String value = (String)clientCacheLoader.load("gudday");
            Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        }
    }
}

