/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.expiry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.Duration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DurationTest {
    @Test
    public void shouldCreateEternalDurationUsingDefaultConstructor() {
        Duration duration = new Duration();
        Assert.assertThat((Object)duration.isEternal(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)duration.isZero(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldCreateEternalDurationWithNullTimeUnitAndAmount() {
        Duration duration = new Duration(null, 0L);
        Assert.assertThat((Object)duration.isEternal(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)duration.isZero(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotCreateDurationWithNullTimeUnit() {
        new Duration(null, 1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateDurationWithNegativeAmount() {
        new Duration(TimeUnit.MINUTES, -1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateDurationWithNegativeStartRangeAmount() {
        new Duration(-1L, 1L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateDurationWithNegativeEndRangeAmount() {
        new Duration(1L, -1L);
    }

    @Test
    public void shouldBeEqualWithSameTimeUnitAndAmount() {
        Duration duration1 = new Duration(TimeUnit.DAYS, 2L);
        Duration duration2 = new Duration(TimeUnit.DAYS, 2L);
        Assert.assertThat((Object)duration1.equals((Object)duration2), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)duration1.hashCode(), (Matcher)CoreMatchers.equalTo((Object)duration2.hashCode()));
    }

    @Test
    public void shouldNotBeEqualWithSameTimeUnitAndDifferentAmount() {
        Duration duration1 = new Duration(TimeUnit.DAYS, 2L);
        Duration duration2 = new Duration(TimeUnit.DAYS, 3L);
        Assert.assertThat((Object)duration1.equals((Object)duration2), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotBeEqualWithDifferentTimeUnitAndAmount() {
        Duration duration1 = new Duration(TimeUnit.DAYS, 2L);
        Duration duration2 = new Duration(TimeUnit.MINUTES, 2L);
        Assert.assertThat((Object)duration1.equals((Object)duration2), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldCompareSemanticallyEquivalentDurationsWithDifferentDurations() {
        Duration duration1 = new Duration(TimeUnit.SECONDS, 120L);
        Duration duration2 = new Duration(TimeUnit.MINUTES, 2L);
        Assert.assertThat((Object)duration1, (Matcher)CoreMatchers.equalTo((Object)duration2));
        Assert.assertThat((Object)duration1.hashCode(), (Matcher)CoreMatchers.equalTo((Object)duration2.hashCode()));
    }

    @Test
    public void shouldCreateZeroDurationWithNoRange() {
        Duration duration = new Duration(0L, 0L);
        Assert.assertThat((Object)duration.isZero(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shouldCreateDurationWithRangeOfCorrectSize() {
        Duration duration = new Duration(0L, 10L);
        Assert.assertThat((Object)duration.isZero(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Object)duration.getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.MILLISECONDS)));
        Assert.assertThat((Object)duration.getDurationAmount(), (Matcher)CoreMatchers.is((Object)10L));
    }

    @Test
    public void shouldCompareZeroDurations() {
        HashMap<TimeUnit, Duration> durations = new HashMap<TimeUnit, Duration>();
        for (TimeUnit timeUnit : TimeUnit.values()) {
            if (timeUnit == TimeUnit.MICROSECONDS || timeUnit == TimeUnit.NANOSECONDS) continue;
            durations.put(timeUnit, new Duration(timeUnit, 0L));
        }
        for (TimeUnit timeUnit : durations.keySet()) {
            for (Duration duration : durations.values()) {
                Assert.assertThat((Object)duration, (Matcher)CoreMatchers.equalTo(durations.get((Object)timeUnit)));
                Assert.assertThat((Object)duration.isZero(), (Matcher)CoreMatchers.is((Object)true));
                Assert.assertThat((Object)duration.isEternal(), (Matcher)CoreMatchers.is((Object)false));
            }
        }
    }

    @Test
    public void shouldCreateNonZeroDurations() {
        HashMap<TimeUnit, Duration> durations = new HashMap<TimeUnit, Duration>();
        for (TimeUnit timeUnit : TimeUnit.values()) {
            if (timeUnit == TimeUnit.MICROSECONDS || timeUnit == TimeUnit.NANOSECONDS) continue;
            durations.put(timeUnit, new Duration(timeUnit, 42L));
        }
        for (TimeUnit timeUnit : durations.keySet()) {
            Duration duration = (Duration)durations.get((Object)timeUnit);
            Assert.assertThat((Object)duration.getDurationAmount(), (Matcher)CoreMatchers.is((Object)42L));
            Assert.assertThat((Object)((Object)duration.getTimeUnit()), (Matcher)CoreMatchers.equalTo((Object)((Object)timeUnit)));
            Assert.assertThat((Object)duration.isZero(), (Matcher)CoreMatchers.is((Object)false));
            Assert.assertThat((Object)duration.isEternal(), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateNanosecondBasedDuration() {
        new Duration(TimeUnit.NANOSECONDS, 0L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotCreateMicrosecondBasedDuration() {
        new Duration(TimeUnit.MICROSECONDS, 0L);
    }

    @Test
    public void shouldCompareDurationWithNull() {
        Duration duration = new Duration(TimeUnit.MINUTES, 42L);
        Assert.assertThat((Object)duration.equals(null), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldCompareDurationWithAnotherType() {
        Duration duration = new Duration(TimeUnit.MINUTES, 42L);
        Assert.assertThat((Object)duration.equals((Object)"Hello World"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldDefineExpectedStaticConstantDurations() {
        Assert.assertThat((Object)((Object)Duration.ONE_MINUTE.getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.MINUTES)));
        Assert.assertThat((Object)Duration.ONE_MINUTE.getDurationAmount(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((Object)Duration.FIVE_MINUTES.getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.MINUTES)));
        Assert.assertThat((Object)Duration.FIVE_MINUTES.getDurationAmount(), (Matcher)CoreMatchers.is((Object)5L));
        Assert.assertThat((Object)((Object)Duration.TEN_MINUTES.getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.MINUTES)));
        Assert.assertThat((Object)Duration.TEN_MINUTES.getDurationAmount(), (Matcher)CoreMatchers.is((Object)10L));
        Assert.assertThat((Object)((Object)Duration.TWENTY_MINUTES.getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.MINUTES)));
        Assert.assertThat((Object)Duration.TWENTY_MINUTES.getDurationAmount(), (Matcher)CoreMatchers.is((Object)20L));
        Assert.assertThat((Object)((Object)Duration.THIRTY_MINUTES.getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.MINUTES)));
        Assert.assertThat((Object)Duration.THIRTY_MINUTES.getDurationAmount(), (Matcher)CoreMatchers.is((Object)30L));
        Assert.assertThat((Object)((Object)Duration.ONE_HOUR.getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.HOURS)));
        Assert.assertThat((Object)Duration.ONE_HOUR.getDurationAmount(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)((Object)Duration.ONE_DAY.getTimeUnit()), (Matcher)CoreMatchers.is((Object)((Object)TimeUnit.DAYS)));
        Assert.assertThat((Object)Duration.ONE_DAY.getDurationAmount(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void shouldHaveDifferentValuesForStaticallyDeclaredDurations() throws IllegalAccessException {
        List<Duration> durations = this.getStaticallyDeclaredDurations();
        Assert.assertThat((Object)durations.size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0)));
        for (Duration a : durations) {
            for (Duration b : durations) {
                if (a == b) continue;
                Assert.assertThat((Object)a.equals((Object)b), (Matcher)CoreMatchers.is((Object)false));
                Assert.assertThat((Object)a.hashCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)b.hashCode())));
            }
        }
    }

    @Test
    public void shouldSerializeAndDeserializeAllStaticallyDeclaredDurations() throws IllegalAccessException, IOException, ClassNotFoundException {
        List<Duration> durations = this.getStaticallyDeclaredDurations();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        for (Duration duration : durations) {
            oos.writeObject(duration);
        }
        oos.close();
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        for (Duration duration : durations) {
            Object object = ois.readObject();
            Assert.assertThat((Object)duration, (Matcher)CoreMatchers.equalTo((Object)object));
        }
        ois.close();
    }

    @Test
    public void testDurationConstructor() {
        junit.framework.Assert.assertNotNull((Object)new Duration(Long.MAX_VALUE, 0L));
        junit.framework.Assert.assertNotNull((Object)new Duration(0L, Long.MAX_VALUE));
    }

    public List<Duration> getStaticallyDeclaredDurations() throws IllegalAccessException {
        ArrayList<Duration> durations = new ArrayList<Duration>();
        Class<Duration> durationClass = Duration.class;
        for (Field field : durationClass.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(Duration.class) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            durations.add((Duration)field.get(null));
        }
        return durations;
    }
}

