/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.integration;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.cache.integration.CompletionListenerFuture;
import org.junit.Assert;
import org.junit.Test;

public class CompletionListenerFutureTest {
    @Test(expected=IllegalStateException.class)
    public void testOnCompletionIllegalStateExceptionThrown() {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onCompletion();
        future.onCompletion();
    }

    @Test(expected=IllegalStateException.class)
    public void testOnExceptionIllegalStateExceptionThrown() {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onException((Exception)new IllegalStateException());
        future.onException((Exception)new IllegalStateException());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testCancel() {
        CompletionListenerFuture future = new CompletionListenerFuture();
        Assert.assertFalse((boolean)future.isCancelled());
        future.cancel(true);
    }

    @Test
    public void testTimedGetNoWait() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onCompletion();
        future.get(3L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testTimedGet() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onCompletion();
        future.get(3L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=TimeoutException.class)
    public void testTimedGetTimeOutException() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.get(3L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=ExecutionException.class)
    public void testTimedGetOnException() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onException((Exception)new IllegalStateException());
        future.get(3L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testGetCompleted() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onCompletion();
        future.get();
    }

    @Test(expected=ExecutionException.class)
    public void testGetOnException() throws TimeoutException, ExecutionException, InterruptedException {
        CompletionListenerFuture future = new CompletionListenerFuture();
        future.onException((Exception)new IllegalStateException());
        future.get();
    }
}

