/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.concurrent.ExecutionException;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.jsr107.tck.support.CacheClient;
import org.jsr107.tck.support.Operation;

public class CacheEntryListenerClient<K, V>
extends CacheClient
implements CacheEntryListener<K, V>,
CacheEntryCreatedListener<K, V>,
CacheEntryUpdatedListener<K, V>,
CacheEntryRemovedListener<K, V>,
CacheEntryExpiredListener<K, V> {
    public CacheEntryListenerClient(InetAddress address, int port) {
        super(address, port);
        this.client = null;
    }

    public void onCreated(Iterable<CacheEntryEvent<? extends K, ? extends V>> cacheEntryEvents) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, V> cacheEntryEvent : cacheEntryEvents) {
            this.getClient().invoke(new OnCacheEntryEventHandler<K, V>(cacheEntryEvent));
        }
    }

    public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> cacheEntryEvents) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, V> cacheEntryEvent : cacheEntryEvents) {
            this.getClient().invoke(new OnCacheEntryEventHandler<K, V>(cacheEntryEvent));
        }
    }

    public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends V>> cacheEntryEvents) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, V> cacheEntryEvent : cacheEntryEvents) {
            this.getClient().invoke(new OnCacheEntryEventHandler<K, V>(cacheEntryEvent));
        }
    }

    public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> cacheEntryEvents) throws CacheEntryListenerException {
        for (CacheEntryEvent<K, V> cacheEntryEvent : cacheEntryEvents) {
            this.getClient().invoke(new OnCacheEntryEventHandler<K, V>(cacheEntryEvent));
        }
    }

    private static class OnCacheEntryEventHandler<K, V>
    implements Operation<Object> {
        private CacheEntryEvent event;

        public OnCacheEntryEventHandler(CacheEntryEvent<? extends K, ? extends V> event) {
            this.event = event;
        }

        @Override
        public String getType() {
            return this.event.getEventType().name();
        }

        @Override
        public Object onInvoke(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException, ExecutionException {
            Object result = null;
            try {
                oos.writeUTF(this.event.getSource().getName());
                oos.writeObject(this.event.getSource().getCacheManager().getURI());
                oos.writeObject(this.event.getKey());
                oos.writeObject(this.event.getValue());
                result = ois.readObject();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (result instanceof CacheEntryListenerException) {
                throw (CacheEntryListenerException)((Object)result);
            }
            return null;
        }
    }
}

