/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import javax.cache.Cache;
import javax.cache.integration.CacheWriter;
import org.jsr107.tck.support.OperationHandler;
import org.jsr107.tck.support.Server;

public class CacheWriterServer<K, V>
extends Server {
    private CacheWriter<K, V> cacheWriter;

    public CacheWriterServer(int port, CacheWriter<K, V> cacheWriter) {
        super(port);
        this.addOperationHandler(new WriteOperationHandler());
        this.addOperationHandler(new WriteAllOperationHandler());
        this.addOperationHandler(new DeleteOperationHandler());
        this.addOperationHandler(new DeleteAllOperationHandler());
        this.cacheWriter = cacheWriter;
    }

    public void setCacheWriter(CacheWriter<K, V> cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    public class WriteOperationHandler
    implements OperationHandler {
        @Override
        public String getType() {
            return "write";
        }

        @Override
        public void onProcess(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            if (CacheWriterServer.this.cacheWriter == null) {
                throw new NullPointerException("The cacheWriter for the CacheWriterServer has not be set");
            }
            Object key = ois.readObject();
            Object value = ois.readObject();
            Entry<Object, Object> entry = new Entry<Object, Object>(key, value);
            try {
                if (key != null && value != null) {
                    CacheWriterServer.this.cacheWriter.write(entry);
                }
            }
            catch (Exception e) {
                oos.writeObject(e);
                return;
            }
            oos.writeObject(null);
        }
    }

    public class WriteAllOperationHandler
    implements OperationHandler {
        @Override
        public String getType() {
            return "writeAll";
        }

        private Collection<Cache.Entry<? extends K, ? extends V>> readEntries(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            Entry<Object, Object> entry;
            HashSet entrys = new HashSet();
            Object key = ois.readObject();
            Object value = null;
            if (key != null) {
                value = ois.readObject();
            }
            Entry<Object, Object> entry2 = entry = key == null || value == null ? null : new Entry<Object, Object>(key, value);
            while (entry != null) {
                entrys.add(entry);
                key = ois.readObject();
                value = null;
                if (key != null) {
                    value = ois.readObject();
                }
                entry = key == null || value == null ? null : new Entry<Object, Object>(key, value);
            }
            return entrys;
        }

        @Override
        public void onProcess(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            if (CacheWriterServer.this.cacheWriter == null) {
                throw new NullPointerException("The cacheWriter for the CacheWriterServer has not be set");
            }
            Collection entrys = this.readEntries(ois);
            try {
                CacheWriterServer.this.cacheWriter.writeAll(entrys);
            }
            catch (Exception e) {
                oos.writeObject(e);
                for (Cache.Entry entry : entrys) {
                    oos.writeObject(entry.getKey());
                }
                oos.writeObject(null);
                return;
            }
            assert (entrys.size() == 0);
            oos.writeObject(null);
        }
    }

    private static class Entry<K, V>
    implements Cache.Entry<K, V> {
        private final K key;
        private final V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public <T> T unwrap(Class<T> clazz) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    public class DeleteOperationHandler
    implements OperationHandler {
        @Override
        public String getType() {
            return "delete";
        }

        @Override
        public void onProcess(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            if (CacheWriterServer.this.cacheWriter == null) {
                throw new NullPointerException("The cacheWriter for the CacheWriterServer has not be set");
            }
            Object key = ois.readObject();
            try {
                CacheWriterServer.this.cacheWriter.delete(key);
            }
            catch (Exception e) {
                oos.writeObject(e);
                return;
            }
            oos.writeObject(null);
        }
    }

    public class DeleteAllOperationHandler
    implements OperationHandler {
        @Override
        public String getType() {
            return "deleteAll";
        }

        @Override
        public void onProcess(ObjectInputStream ois, ObjectOutputStream oos) throws IOException, ClassNotFoundException {
            if (CacheWriterServer.this.cacheWriter == null) {
                throw new NullPointerException("The cacheWriter for the CacheWriterServer has not be set");
            }
            HashSet<Object> keys = new HashSet<Object>();
            Object key = ois.readObject();
            while (key != null) {
                keys.add(key);
                key = ois.readObject();
            }
            try {
                CacheWriterServer.this.cacheWriter.deleteAll(keys);
            }
            catch (Exception e) {
                oos.writeObject(e);
                oos.writeObject(keys);
                return;
            }
            oos.writeObject(keys);
        }
    }
}

