/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck;

import domain.Identifier2;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class GetTest
extends CacheTestSupport<Long, String> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass());

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Long.class, String.class);
    }

    @Override
    protected MutableConfiguration<Long, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Long.class, String.class);
    }

    @Test
    public void get_Closed() {
        this.cache.close();
        try {
            this.cache.get(null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void get_NullKey() {
        try {
            Assert.assertNull((Object)this.cache.get(null));
            Assert.fail((String)"should have thrown an exception - null key not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void get_NotExisting() {
        Long existingKey = System.currentTimeMillis();
        String existingValue = "value" + existingKey;
        this.cache.put((Object)existingKey, (Object)existingValue);
        Long key1 = existingKey + 1L;
        Assert.assertNull((Object)this.cache.get((Object)key1));
    }

    @Test
    public void get_Existing() {
        Long existingKey = System.currentTimeMillis();
        String existingValue = "value" + existingKey;
        this.cache.put((Object)existingKey, (Object)existingValue);
        Assert.assertEquals((Object)existingValue, (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void get_Existing_NotSameKey() {
        Long existingKey = System.currentTimeMillis();
        String existingValue = "value" + existingKey;
        this.cache.put((Object)existingKey, (Object)existingValue);
        Assert.assertEquals((Object)existingValue, (Object)this.cache.get((Object)new Long(existingKey)));
    }

    @Test
    public void getAll_Closed() {
        this.cache.close();
        try {
            this.cache.getAll(null);
            Assert.fail((String)"should have thrown an exception - cache closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getAll_Null() {
        try {
            this.cache.getAll(null);
            Assert.fail((String)"should have thrown an exception - null keys not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getAll_NullKey() {
        HashSet<Long> keys = new HashSet<Long>();
        keys.add(1L);
        keys.add(null);
        keys.add(2L);
        try {
            this.cache.getAll(keys);
            Assert.fail((String)"should have thrown an exception - null key in keys not allowed");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void getAll() {
        ArrayList<Long> keysInCache = new ArrayList<Long>();
        keysInCache.add(1L);
        keysInCache.add(2L);
        for (Long k : keysInCache) {
            this.cache.put((Object)k, (Object)("value" + k));
        }
        HashSet<Long> keysToGet = new HashSet<Long>();
        keysToGet.add(2L);
        keysToGet.add(3L);
        HashSet<Long> keysExpected = new HashSet<Long>();
        keysExpected.add(2L);
        Map map = this.cache.getAll(keysToGet);
        Assert.assertEquals((String)"size", (long)keysExpected.size(), (long)map.size());
        for (Long key : keysExpected) {
            Assert.assertTrue((boolean)map.containsKey(key));
            Assert.assertEquals((String)("key  : key=" + key), (Object)this.cache.get((Object)key), map.get(key));
            Assert.assertEquals((String)("value: key=" + key), (Object)("value" + key), map.get(key));
        }
    }

    public void testGetUsesEqualityNotequalsequals() {
        Cache identifier2Cache = this.getCacheManager().createCache("identifierCache", (Configuration)this.newMutableConfiguration().setStoreByValue(false));
        Identifier2 one = new Identifier2("1");
        identifier2Cache.put((Object)one, (Object)"something");
        Identifier2 one_ = new Identifier2("1");
        junit.framework.Assert.assertEquals((Object)one, (Object)one_);
        junit.framework.Assert.assertEquals((int)one.hashCode(), (int)one_.hashCode());
        Assert.assertEquals((Object)"something", (Object)identifier2Cache.get((Object)one_));
    }
}

