/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.event;

import java.util.ArrayList;
import javax.cache.event.EventType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsr107.tck.event.CacheEntryListenerClient;
import org.jsr107.tck.event.CacheEntryListenerServer;
import org.jsr107.tck.event.TestCacheEntryEvent;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class CacheEntryListenerClientServerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHandleCacheEntryEventFromServerWithClient() {
        CacheTestSupport.MyCacheEntryListener listener = new CacheTestSupport.MyCacheEntryListener();
        serverListener.addCacheEventListener(listener);
        try (CacheEntryListenerServer serverListener = new CacheEntryListenerServer(10011, String.class, String.class);){
            serverListener.open();
            CacheEntryListenerClient<Object, Object> clientListener = new CacheEntryListenerClient<Object, Object>(serverListener.getInetAddress(), serverListener.getPort());
            TestCacheEntryEvent<String, String> event = new TestCacheEntryEvent<String, String>(null, EventType.CREATED);
            event.setKey("key");
            event.setValue("value");
            event.setOldValueAvailable(false);
            ArrayList events = new ArrayList();
            events.add(event);
            clientListener.onCreated(events);
            Assert.assertThat((Object)listener.getCreated(), (Matcher)CoreMatchers.is((Object)1));
            clientListener.onRemoved(events);
            Assert.assertThat((Object)listener.getRemoved(), (Matcher)CoreMatchers.is((Object)0));
            event = new TestCacheEntryEvent(null, EventType.UPDATED);
            event.setKey("key");
            event.setValue("value");
            event.setOldValue("oldValue");
            event.setOldValueAvailable(true);
            events.clear();
            events.add(event);
            clientListener.onUpdated(events);
            Assert.assertThat((Object)listener.getUpdated(), (Matcher)CoreMatchers.is((Object)1));
            Assert.assertThat((Object)listener.getCreated(), (Matcher)CoreMatchers.is((Object)1));
        }
    }

    @Test
    public void testMultipleTimes() {
        for (int i = 0; i < 10; ++i) {
            this.shouldHandleCacheEntryEventFromServerWithClient();
        }
    }
}

