/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.annotation;

import java.util.Iterator;
import java.util.ServiceLoader;
import javax.cache.annotation.BeanProvider;
import org.jsr107.tck.testutil.AbstractTestExcluder;
import org.junit.Rule;
import org.junit.rules.MethodRule;

public class AbstractInterceptionTest {
    private static final BeanProvider beanProvider;
    @Rule
    public final MethodRule rule = new AbstractTestExcluder(){

        @Override
        protected boolean isExcluded(String methodName) {
            return beanProvider == null;
        }
    };

    protected final <T> T getBeanByType(Class<T> beanClass) {
        if (beanProvider == null) {
            throw new IllegalStateException("No tests should be run if beanProvider is null");
        }
        return beanProvider.getBeanByType(beanClass);
    }

    static {
        BeanProvider localBeanProvider = null;
        try {
            ServiceLoader<BeanProvider> serviceLoader = ServiceLoader.load(BeanProvider.class);
            Iterator<BeanProvider> it = serviceLoader.iterator();
            localBeanProvider = it.hasNext() ? it.next() : null;
        }
        catch (Throwable t) {
            System.err.println("Failed to load BeanProvider SPI impl, annotation tests will be ignored");
            t.printStackTrace(System.err);
        }
        beanProvider = localBeanProvider;
    }
}

