/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.management;

import java.net.URI;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsEmptyCollection;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.jsr107.tck.testutil.TestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CacheManagerManagementTest {
    private CacheManager cacheManager;
    public static final int EMPTY = 0;
    private MBeanServer mBeanServer;
    MutableConfiguration<Integer, String> configuration = new MutableConfiguration().setStatisticsEnabled(true).setManagementEnabled(true);
    private Cache<Integer, String> cache1;
    private Cache<Integer, String> cache2;
    @Rule
    public ExcludeListExcluder rule = new ExcludeListExcluder(this.getClass());

    public static CacheManager getCacheManager() throws Exception {
        CachingProvider provider = Caching.getCachingProvider();
        URI uri = provider.getDefaultURI();
        return Caching.getCachingProvider().getCacheManager(uri, provider.getDefaultClassLoader());
    }

    @Before
    public void setUp() throws Exception {
        Caching.getCachingProvider().close();
        this.cacheManager = CacheManagerManagementTest.getCacheManager();
        this.cacheManager.createCache("ensure_mbeanserver_created_cache", this.configuration);
        this.cacheManager.destroyCache("ensure_mbeanserver_created_cache");
        this.mBeanServer = TestSupport.resolveMBeanServer();
    }

    @After
    public void tearDown() throws MalformedObjectNameException {
        if (!this.cacheManager.isClosed()) {
            for (String cacheName : this.cacheManager.getCacheNames()) {
                this.cacheManager.destroyCache(cacheName);
            }
        }
        this.cacheManager.close();
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testNoEntriesWhenNoCaches() throws Exception {
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testJMXGetsCacheAdditionsAndRemovals() throws Exception {
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)0));
        this.cacheManager.createCache("new cache", this.configuration);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.cacheManager.destroyCache("sampleCache1");
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.cacheManager.destroyCache("new cache");
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testMultipleCacheManagers() throws Exception {
        this.cacheManager.createCache("new cache", this.configuration);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)2));
        CacheManager cacheManager2 = CacheManagerManagementTest.getCacheManager();
        cacheManager2.createCache("other cache", this.configuration);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)4));
        this.cacheManager.destroyCache("new cache");
        cacheManager2.destroyCache("other cache");
        cacheManager2.close();
    }

    @Test
    public void testDoubleRegistration() throws MalformedObjectNameException {
        this.cacheManager.createCache("new cache", this.configuration);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.cacheManager.enableStatistics("new cache", true);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void testCacheStatisticsOffThenOnThenOff() throws Exception {
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setStatisticsEnabled(false);
        this.cacheManager.createCache("cache1", (Configuration)configuration);
        this.cacheManager.createCache("cache2", (Configuration)configuration);
        Set<ObjectName> names = this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null);
        Assert.assertTrue((names.size() == 0 ? 1 : 0) != 0);
        configuration.setStatisticsEnabled(true);
        this.cacheManager.createCache("cache3", (Configuration)configuration);
        this.cacheManager.createCache("cache4", (Configuration)configuration);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.cacheManager.enableStatistics("cache3", false);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.cacheManager.enableStatistics("cache3", true);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)2));
    }

    @Test
    public void testCacheManagementOffThenOnThenOff() throws Exception {
        MutableConfiguration configuration = new MutableConfiguration();
        configuration.setManagementEnabled(false);
        this.cacheManager.createCache("cache1", (Configuration)configuration);
        this.cacheManager.createCache("cache2", (Configuration)configuration);
        Set<ObjectName> names = this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null);
        Assert.assertTrue((names.size() == 0 ? 1 : 0) != 0);
        configuration.setManagementEnabled(true);
        this.cacheManager.createCache("cache3", (Configuration)configuration);
        this.cacheManager.createCache("cache4", (Configuration)configuration);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.cacheManager.enableManagement("cache3", false);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.cacheManager.enableManagement("cache3", true);
        Assert.assertThat(this.mBeanServer.queryNames(new ObjectName("javax.cache:*"), null), (Matcher)IsCollectionWithSize.hasSize((int)2));
    }
}

