/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck;

import domain.Beagle;
import domain.BorderCollie;
import domain.Chihuahua;
import domain.Dachshund;
import domain.Hound;
import domain.Identifier;
import domain.Identifier2;
import domain.Papillon;
import domain.RoughCoatedCollie;
import domain.Sex;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.configuration.OptionalFeature;
import junit.framework.TestCase;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class TypesTest
extends CacheTestSupport<Identifier, String> {
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass()){

        @Override
        protected boolean isExcluded(String methodName) {
            return "simpleAPINoGenericsAndNoTypeEnforcementStoreByReference".equals(methodName) && !TypesTest.this.cacheManager.getCachingProvider().isSupported(OptionalFeature.STORE_BY_REFERENCE) || super.isExcluded(methodName);
        }
    };
    private CacheManager cacheManager = this.getCacheManager();
    private Beagle pistachio = (Beagle)new Beagle().name(new Identifier("Pistachio")).color("tricolor").sex(Sex.MALE).weight(7).length(50L).height(30L).neutered(false);
    private RoughCoatedCollie juno = (RoughCoatedCollie)new RoughCoatedCollie().name(new Identifier("Juno")).sex(Sex.MALE).weight(7);
    private Dachshund skinny = (Dachshund)new Dachshund().name(new Identifier("Skinny")).sex(Sex.MALE).weight(5).neutered(true);
    private Chihuahua tonto = (Chihuahua)new Chihuahua().name(new Identifier("Tonto")).weight(3).sex(Sex.MALE).neutered(false);
    private BorderCollie bonzo = (BorderCollie)new BorderCollie().name(new Identifier("Bonzo")).color("tricolor").sex(Sex.FEMALE).weight(10);
    private Papillon talker = (Papillon)new Papillon().name(new Identifier("Talker")).color("Black and White").weight(4).sex(Sex.MALE);
    private final String cacheName = "sampleCache";

    @Override
    protected MutableConfiguration<Identifier, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Identifier.class, String.class);
    }

    @Override
    @After
    public void teardown() {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            this.cacheManager.destroyCache(cacheName);
        }
        this.cacheManager.close();
    }

    @Test
    public void sanityCheckTestDomain() {
        Identifier pistachio2Id = new Identifier("Pistachio");
        Beagle pistachio2 = (Beagle)new Beagle().name(pistachio2Id).color("tricolor").sex(Sex.MALE).weight(7).length(50L).height(30L).neutered(false);
        Identifier pistachio3Id = new Identifier("Pistachio 2");
        Beagle pistachio3 = (Beagle)new Beagle().name(pistachio3Id).color("tricolor").sex(Sex.MALE).weight(7).length(50L).height(30L).neutered(true);
        Assert.assertNotEquals((Object)pistachio2Id, (Object)pistachio3Id);
        Assert.assertNotEquals((long)pistachio2Id.hashCode(), (long)pistachio3Id.hashCode());
        Identifier2 id2 = new Identifier2("22");
        Identifier2 id3 = new Identifier2("23");
        Assert.assertNotEquals((Object)id2, (Object)id3);
        Assert.assertNotEquals((long)id2.hashCode(), (long)id3.hashCode());
        TestCase.assertEquals((Object)this.pistachio, (Object)pistachio2);
        TestCase.assertEquals((int)this.pistachio.hashCode(), (int)pistachio2.hashCode());
        Assert.assertNotEquals((Object)this.pistachio, (Object)pistachio3);
        Assert.assertNotEquals((long)this.pistachio.hashCode(), (long)pistachio3.hashCode());
        this.pistachio.bay(10, 30);
        this.skinny.bay(20, 32);
        this.juno.herd();
    }

    @Test
    public void simpleAPINoGenericsAndNoTypeEnforcementStoreByReference() {
        MutableConfiguration config = new MutableConfiguration().setStoreByValue(false);
        Cache cache = this.cacheManager.createCache("sampleCache", (Configuration)config);
        Identifier2 one = new Identifier2("1");
        cache.put((Object)one, (Object)"something");
        cache.put((Object)this.pistachio.getName(), (Object)this.pistachio);
        cache.put((Object)this.tonto.getName(), (Object)this.tonto);
        cache.put((Object)this.bonzo.getName(), (Object)this.bonzo);
        cache.put((Object)this.juno.getName(), (Object)this.juno);
        cache.put((Object)this.talker.getName(), (Object)this.talker);
        try {
            cache.put((Object)this.skinny.getName(), (Object)this.skinny);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Identifier2 one_ = new Identifier2("1");
        junit.framework.Assert.assertEquals((Object)one, (Object)one_);
        junit.framework.Assert.assertEquals((int)one.hashCode(), (int)one_.hashCode());
        TestCase.assertNotNull((Object)cache.get((Object)one_));
        TestCase.assertNotNull((Object)cache.get((Object)one));
        TestCase.assertNotNull((Object)cache.get((Object)this.pistachio.getName()));
        Assert.assertTrue((boolean)cache.remove((Object)one));
        Assert.assertTrue((boolean)cache.remove((Object)this.pistachio.getName()));
    }

    @Test
    public void simpleAPINoGenericsAndNoTypeEnforcementStoreByValue() {
        MutableConfiguration config = new MutableConfiguration();
        Cache cache = this.cacheManager.createCache("sampleCache", (Configuration)config);
        Identifier2 one = new Identifier2("1");
        cache.put((Object)1L, (Object)"something");
        cache.put((Object)this.pistachio.getName(), (Object)this.pistachio);
        cache.put((Object)this.tonto.getName(), (Object)this.tonto);
        cache.put((Object)this.bonzo.getName(), (Object)this.bonzo);
        cache.put((Object)this.juno.getName(), (Object)this.juno);
        cache.put((Object)this.talker.getName(), (Object)this.talker);
        try {
            cache.put((Object)this.skinny.getName(), (Object)this.skinny);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestCase.assertNotNull((Object)cache.get((Object)1L));
        TestCase.assertNotNull((Object)cache.get((Object)this.pistachio.getName()));
        Assert.assertTrue((boolean)cache.remove((Object)1L));
        Assert.assertTrue((boolean)cache.remove((Object)this.pistachio.getName()));
    }

    @Test
    public void simpleAPIWithGenericsAndNoTypeEnforcement() {
        MutableConfiguration config = new MutableConfiguration();
        Cache cache = this.cacheManager.createCache("sampleCache", (Configuration)config);
        cache.put((Object)this.pistachio.getName(), (Object)this.pistachio);
        cache.put((Object)this.tonto.getName(), (Object)this.tonto);
        TestCase.assertNotNull((Object)cache.get((Object)this.pistachio.getName()));
        TestCase.assertNotNull((Object)cache.get((Object)this.tonto.getName()));
        Assert.assertTrue((boolean)cache.remove((Object)this.pistachio.getName()));
        Assert.assertTrue((boolean)cache.remove((Object)this.tonto.getName()));
    }

    @Test
    public void genericsEnforcementAndStricterTypeEnforcement() {
        MutableConfiguration config = new MutableConfiguration();
        config.setTypes(Identifier.class, Hound.class);
        Cache cache = this.cacheManager.createCache("sampleCache", (Configuration)config);
        cache.put((Object)this.pistachio.getName(), (Object)this.pistachio);
        try {
            cache.put((Object)this.tonto.getName(), (Object)this.tonto);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        TestCase.assertNotNull((Object)cache.get((Object)this.pistachio.getName()));
        Assert.assertTrue((boolean)cache.remove((Object)this.pistachio.getName()));
    }

    @Test
    public void genericsEnforcementAndStricterTypeEnforcementFromCaching() {
        MutableConfiguration config = new MutableConfiguration();
        config.setTypes(Identifier.class, Hound.class);
        Cache cache = this.cacheManager.createCache("sampleCache", (Configuration)config);
        cache.put((Object)this.pistachio.getName(), (Object)this.pistachio);
        try {
            cache.put((Object)this.tonto.getName(), (Object)this.tonto);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        TestCase.assertNotNull((Object)cache.get((Object)this.pistachio.getName()));
        Assert.assertTrue((boolean)cache.remove((Object)this.pistachio.getName()));
    }

    @Test
    public void simpleAPITypeEnforcementObject() {
        MutableConfiguration config = new MutableConfiguration();
        config.setTypes(Object.class, Object.class);
        Cache cache = this.cacheManager.createCache("simpleCache4", (Configuration)config);
        cache.put((Object)1, (Object)"something");
        cache.put((Object)this.pistachio.getName(), (Object)this.pistachio);
        cache.put((Object)this.tonto.getName(), (Object)this.tonto);
        cache.put((Object)this.bonzo.getName(), (Object)this.bonzo);
        cache.put((Object)this.juno.getName(), (Object)this.juno);
        cache.put((Object)this.talker.getName(), (Object)this.talker);
        try {
            cache.put((Object)this.skinny.getName(), (Object)this.skinny);
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestCase.assertNotNull((Object)cache.get((Object)1));
        TestCase.assertNotNull((Object)cache.get((Object)this.pistachio.getName()));
        Assert.assertTrue((boolean)cache.remove((Object)1));
        Assert.assertTrue((boolean)cache.remove((Object)this.pistachio.getName()));
    }
}

