/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsr107.tck.integration.CacheLoaderClient;
import org.jsr107.tck.integration.CacheLoaderServer;
import org.jsr107.tck.integration.FailingCacheLoader;
import org.jsr107.tck.integration.NullValueCacheLoader;
import org.jsr107.tck.integration.RecordingCacheLoader;
import org.junit.Assert;
import org.junit.Test;

public class CacheLoaderClientServerTest {
    @Test
    public void shouldLoadFromServerWithClient() throws Exception {
        RecordingCacheLoader<String> recordingCacheLoader = new RecordingCacheLoader<String>();
        CacheLoaderServer serverCacheLoader = new CacheLoaderServer(10000, recordingCacheLoader);
        serverCacheLoader.open();
        CacheLoaderClient clientCacheLoader = new CacheLoaderClient(serverCacheLoader.getInetAddress(), serverCacheLoader.getPort());
        String value = (String)clientCacheLoader.load("gudday");
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)"gudday"));
        Assert.assertThat((Object)recordingCacheLoader.hasLoaded("gudday"), (Matcher)CoreMatchers.is((Object)true));
        clientCacheLoader.close();
        serverCacheLoader.close();
    }

    @Test
    public void shouldRethrowExceptions() throws Exception {
        FailingCacheLoader failingCacheLoader = new FailingCacheLoader();
        CacheLoaderServer serverCacheLoader = new CacheLoaderServer(10000, failingCacheLoader);
        serverCacheLoader.open();
        CacheLoaderClient clientCacheLoader = new CacheLoaderClient(serverCacheLoader.getInetAddress(), serverCacheLoader.getPort());
        try {
            String value = (String)clientCacheLoader.load("gudday");
            Assert.fail((String)"An UnsupportedOperationException should have been thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        clientCacheLoader.close();
        serverCacheLoader.close();
    }

    @Test
    public void shouldLoadNullValuesFromServerWithClient() throws Exception {
        NullValueCacheLoader nullCacheLoader = new NullValueCacheLoader();
        CacheLoaderServer serverCacheLoader = new CacheLoaderServer(10000, nullCacheLoader);
        serverCacheLoader.open();
        CacheLoaderClient clientCacheLoader = new CacheLoaderClient(serverCacheLoader.getInetAddress(), serverCacheLoader.getPort());
        String value = (String)clientCacheLoader.load("gudday");
        Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        clientCacheLoader.close();
        serverCacheLoader.close();
    }

    @Test(expected=IllegalStateException.class)
    public void clientMustBeClosedBeforeServer() throws Exception {
        NullValueCacheLoader nullCacheLoader = new NullValueCacheLoader();
        CacheLoaderServer serverCacheLoader = new CacheLoaderServer(10000, nullCacheLoader);
        serverCacheLoader.open();
        CacheLoaderClient clientCacheLoader = new CacheLoaderClient(serverCacheLoader.getInetAddress(), serverCacheLoader.getPort());
        clientCacheLoader.load("hi");
        serverCacheLoader.close();
    }
}

