/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.management;

import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jsr107.tck.processor.GetEntryProcessor;
import org.jsr107.tck.processor.NoOpEntryProcessor;
import org.jsr107.tck.processor.RemoveEntryProcessor;
import org.jsr107.tck.processor.SetEntryProcessor;
import org.jsr107.tck.testutil.AssertionUtil;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.jsr107.tck.testutil.TestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class CacheMBStatisticsBeanTest
extends CacheTestSupport<Long, String> {
    public static final String STATISTICS_UPDATE_TIMEOUT_PROPERTY = "org.jsr107.tck.management.statistics.timeout.seconds";
    private static final String DEFAULT_STATISTICS_UPDATE_TIMEOUT_SECONDS = "0";
    private int statisticsUpdateTimeoutMillis;
    @Rule
    public MethodRule rule = new ExcludeListExcluder(this.getClass()){

        @Override
        protected boolean isExcluded(String methodName) {
            if ("testUnwrap".equals(methodName) && CacheMBStatisticsBeanTest.this.getUnwrapClass(CacheManager.class) == null) {
                return true;
            }
            return super.isExcluded(methodName);
        }
    };

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Long.class, String.class);
        this.cache.getCacheManager().enableStatistics(this.cache.getName(), true);
        this.statisticsUpdateTimeoutMillis = Integer.valueOf(System.getProperty(STATISTICS_UPDATE_TIMEOUT_PROPERTY, DEFAULT_STATISTICS_UPDATE_TIMEOUT_SECONDS));
    }

    @Override
    protected MutableConfiguration<Long, String> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Long.class, String.class);
    }

    @Override
    protected MutableConfiguration<Long, String> extraSetup(MutableConfiguration<Long, String> configuration) {
        return configuration.setStoreByValue(true);
    }

    @Test
    public void testCacheStatisticsAllZero() throws Exception {
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime"));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testCacheStatistics() throws Exception {
        float DELTA = 1.0f;
        this.cache.put((Object)1L, (Object)"Sooty");
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        HashMap<Long, String> entries = new HashMap<Long, String>();
        entries.put(2L, "Lucky");
        entries.put(3L, "Prince");
        this.cache.putAll(entries);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.put((Object)1L, (Object)"Sooty");
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)4L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.putAll(entries);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)6L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.getAndPut((Object)4L, (Object)"Cody");
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)7L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.getAndPut((Object)4L, (Object)"Cody");
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)8L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        String value = (String)this.cache.get((Object)1L);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((float)66.0f, (float)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage")).floatValue(), (float)1.0f);
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((float)33.0f, (float)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage")).floatValue(), (float)1.0f);
                Assert.assertEquals((Object)8L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        value = (String)this.cache.get((Object)1234324324L);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)8L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        junit.framework.Assert.assertTrue((boolean)this.cache.containsKey((Object)1L));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1234324324L));
        AssertionUtil.assertAllTheTime(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)8L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        junit.framework.Assert.assertTrue((boolean)this.cache.remove((Object)1L));
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)8L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        junit.framework.Assert.assertFalse((boolean)this.cache.remove((Object)1L));
        AssertionUtil.assertAllTheTime(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)8L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.put((Object)1L, (Object)"Sooty");
        junit.framework.Assert.assertTrue((boolean)this.cache.remove((Object)1L, (Object)"Sooty"));
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((float)60.0f, (float)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage")).floatValue(), (float)1.0f);
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((float)40.0f, (float)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage")).floatValue(), (float)1.0f);
                Assert.assertEquals((Object)9L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        junit.framework.Assert.assertFalse((boolean)this.cache.remove((Object)1L, (Object)"Sooty"));
        AssertionUtil.assertAllTheTime(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)9L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.clear();
        AssertionUtil.assertAllTheTime(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)9L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.removeAll();
        AssertionUtil.assertAllTheTime(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)9L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        entries.put(21L, "Trinity");
        this.cache.putAll(entries);
        this.cache.removeAll();
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)12L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)5L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.putAll(entries);
        entries.remove(21L);
        this.cache.removeAll(entries.keySet());
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)15L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)7L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.removeAll(entries.keySet());
        AssertionUtil.assertAllTheTime(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)3L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(50.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)15L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)7L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testCacheStatisticsInvokeEntryProcessorNoOp() throws Exception {
        this.cache.put((Object)1L, (Object)"Sooty");
        this.cache.invoke((Object)1L, new NoOpEntryProcessor(), new Object[0]);
        this.cache.invoke((Object)1L, new NoOpEntryProcessor(), new Object[0]);
        this.cache.invoke((Object)1000L, new NoOpEntryProcessor(), new Object[0]);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(66.65f)));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage")), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Float.valueOf(33.34f)));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testCacheStatisticsInvokeEntryProcessorGet() throws Exception {
        this.cache.put((Object)1L, (Object)"Sooty");
        String result = (String)this.cache.invoke((Object)1L, new GetEntryProcessor(), new Object[0]);
        this.cache.invoke((Object)1L, new NoOpEntryProcessor(), new Object[0]);
        this.cache.invoke((Object)1000L, new NoOpEntryProcessor(), new Object[0]);
        Assert.assertEquals((Object)"Sooty", (Object)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(66.65f)));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage")), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Float.valueOf(33.34f)));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testCacheStatisticsInvokeEntryProcessorUpdate() throws Exception {
        this.cache.put((Object)1L, (Object)"Sooty");
        String result = (String)this.cache.invoke((Object)1L, new SetEntryProcessor("Trinity"), new Object[0]);
        Assert.assertEquals((Object)"Trinity", (Object)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)2L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testCacheStatisticsInvokeEntryProcessorRemove() throws Exception {
        this.cache.put((Object)1L, (Object)"Sooty");
        String result = (String)this.cache.invoke((Object)1L, new RemoveEntryProcessor(true), new Object[0]);
        Assert.assertEquals((Object)"Sooty", (Object)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testIterateAndRemove() throws Exception {
        for (long i = 0L; i < 100L; ++i) {
            String word = "";
            word = word + " " + "Trinity";
            this.cache.put((Object)i, (Object)word);
        }
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)100L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHitPercentage"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMissPercentage"));
                Assert.assertEquals((Object)100L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheGets"));
                Assert.assertEquals((Object)100L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)100L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheEvictions"));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
                Assert.assertThat((Object)((Float)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Float.valueOf(0.0f)));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testGetAndReplace() throws Exception {
        long hitCount = 0L;
        long missCount = 0L;
        long putCount = 0L;
        String result = (String)this.cache.getAndReplace((Object)1L, (Object)"MissingNoReplace");
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1L));
        Assert.assertEquals(null, (Object)result);
        Assert.assertEquals((Object)(++missCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)putCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1L));
        this.cache.put((Object)1L, (Object)"Sooty");
        junit.framework.Assert.assertTrue((boolean)this.cache.containsKey((Object)1L));
        Assert.assertEquals((Object)missCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)(++putCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        result = (String)this.cache.getAndReplace((Object)2L, (Object)"InvalidReplace");
        Assert.assertEquals(null, (Object)result);
        Assert.assertEquals((Object)(++missCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)hitCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)putCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)2L));
        result = (String)this.cache.getAndReplace((Object)1L, (Object)"Replaced");
        Assert.assertEquals((Object)"Sooty", (Object)result);
        Assert.assertEquals((Object)missCount, (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
        Assert.assertEquals((Object)(++hitCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
        Assert.assertEquals((Object)(++putCount), (Object)CacheMBStatisticsBeanTest.lookupManagementAttribute(this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
    }

    @Test
    public void testReplace() throws Exception {
        final AtomicLong hitCount = new AtomicLong();
        final AtomicLong missCount = new AtomicLong();
        final AtomicLong putCount = new AtomicLong();
        boolean result = this.cache.replace((Object)1L, (Object)"MissingNoReplace");
        missCount.incrementAndGet();
        junit.framework.Assert.assertFalse((boolean)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)missCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)hitCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)putCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                junit.framework.Assert.assertFalse((boolean)CacheMBStatisticsBeanTest.this.cache.containsKey((Object)1L));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.put((Object)1L, (Object)"Sooty");
        putCount.incrementAndGet();
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
            }
        }, this.statisticsUpdateTimeoutMillis);
        junit.framework.Assert.assertTrue((boolean)this.cache.containsKey((Object)1L));
        result = this.cache.replace((Object)2L, (Object)"InvalidReplace");
        missCount.incrementAndGet();
        junit.framework.Assert.assertFalse((boolean)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)missCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)hitCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)putCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                junit.framework.Assert.assertFalse((boolean)CacheMBStatisticsBeanTest.this.cache.containsKey((Object)2L));
            }
        }, this.statisticsUpdateTimeoutMillis);
        result = this.cache.replace((Object)1L, (Object)"Replaced");
        hitCount.incrementAndGet();
        putCount.incrementAndGet();
        junit.framework.Assert.assertTrue((boolean)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)missCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)hitCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)putCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testConditionalReplace() throws Exception {
        final AtomicLong hitCount = new AtomicLong();
        final AtomicLong missCount = new AtomicLong();
        final AtomicLong putCount = new AtomicLong();
        boolean result = this.cache.replace((Object)1L, (Object)"MissingNoReplace", (Object)"NewValue");
        missCount.incrementAndGet();
        junit.framework.Assert.assertFalse((boolean)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)missCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)hitCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)putCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                junit.framework.Assert.assertFalse((boolean)CacheMBStatisticsBeanTest.this.cache.containsKey((Object)1L));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.put((Object)1L, (Object)"Sooty");
        putCount.incrementAndGet();
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)1L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
            }
        }, this.statisticsUpdateTimeoutMillis);
        junit.framework.Assert.assertTrue((boolean)this.cache.containsKey((Object)1L));
        result = this.cache.replace((Object)1L, (Object)"Sooty", (Object)"Replaced");
        hitCount.incrementAndGet();
        putCount.incrementAndGet();
        junit.framework.Assert.assertTrue((boolean)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)missCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)hitCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)putCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
            }
        }, this.statisticsUpdateTimeoutMillis);
        result = this.cache.replace((Object)1L, (Object)"Sooty", (Object)"InvalidReplace");
        hitCount.incrementAndGet();
        junit.framework.Assert.assertFalse((boolean)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)missCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)hitCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)putCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testPutIfAbsent() throws Exception {
        final AtomicLong hitCount = new AtomicLong();
        final AtomicLong missCount = new AtomicLong();
        final AtomicLong putCount = new AtomicLong();
        boolean result = this.cache.putIfAbsent((Object)1L, (Object)"succeeded");
        putCount.incrementAndGet();
        missCount.incrementAndGet();
        junit.framework.Assert.assertTrue((boolean)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)missCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)hitCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)putCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                junit.framework.Assert.assertTrue((boolean)CacheMBStatisticsBeanTest.this.cache.containsKey((Object)1L));
            }
        }, this.statisticsUpdateTimeoutMillis);
        result = this.cache.putIfAbsent((Object)1L, (Object)"succeeded");
        junit.framework.Assert.assertFalse((boolean)result);
        hitCount.incrementAndGet();
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)putCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)missCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)hitCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testGetAndRemove() throws Exception {
        final AtomicLong hitCount = new AtomicLong();
        final AtomicLong missCount = new AtomicLong();
        final AtomicLong removeCount = new AtomicLong();
        String result = (String)this.cache.getAndRemove((Object)1L);
        missCount.incrementAndGet();
        Assert.assertEquals(null, (Object)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)missCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)hitCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)removeCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                junit.framework.Assert.assertFalse((boolean)CacheMBStatisticsBeanTest.this.cache.containsKey((Object)1L));
            }
        }, this.statisticsUpdateTimeoutMillis);
        this.cache.put((Object)1L, (Object)"added");
        result = (String)this.cache.getAndRemove((Object)1L);
        hitCount.incrementAndGet();
        removeCount.incrementAndGet();
        Assert.assertEquals((Object)"added", (Object)result);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)removeCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)missCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)hitCount.get(), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
            }
        }, this.statisticsUpdateTimeoutMillis);
        junit.framework.Assert.assertFalse((boolean)this.cache.containsKey((Object)1L));
    }

    @Test
    public void testExpiryOnCreation() throws Exception {
        CacheManager mgr = this.cache.getCacheManager();
        mgr.destroyCache(this.cache.getName());
        MutableConfiguration config = new MutableConfiguration();
        config.setStatisticsEnabled(true);
        config.setTypes(Long.class, String.class);
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf(ExpireOnCreationPolicy.class));
        this.cache = mgr.createCache(this.getTestCacheName(), (Configuration)config);
        this.cache.put((Object)1L, (Object)"hello");
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
            }
        }, this.statisticsUpdateTimeoutMillis);
        HashMap<Long, String> map = new HashMap<Long, String>();
        map.put(2L, "goodbye");
        map.put(3L, "world");
        this.cache.putAll(map);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    @Test
    public void testClear() throws Exception {
        this.cache.get((Object)1L);
        this.cache.put((Object)1L, (Object)"Sooty");
        this.cache.get((Object)1L);
        this.cache.remove((Object)1L);
        MBeanServer mBeanServer = TestSupport.resolveMBeanServer();
        ObjectName objectName = CacheMBStatisticsBeanTest.calculateObjectName(this.cache, TestSupport.MBeanType.CacheStatistics);
        mBeanServer.invoke(objectName, "clear", null, null);
        AssertionUtil.assertEventually(new AssertionUtil.AssertionRunnable(){

            @Override
            public void run() throws Exception {
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CachePuts"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheHits"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheGets"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheRemovals"));
                Assert.assertEquals((Object)0L, (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "CacheMisses"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageGetTime"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AveragePutTime"));
                Assert.assertEquals((Object)Float.valueOf(0.0f), (Object)TestSupport.lookupManagementAttribute(CacheMBStatisticsBeanTest.this.cache, TestSupport.MBeanType.CacheStatistics, "AverageRemoveTime"));
            }
        }, this.statisticsUpdateTimeoutMillis);
    }

    public static class ExpireOnCreationPolicy
    implements ExpiryPolicy {
        public Duration getExpiryForCreation() {
            return Duration.ZERO;
        }

        public Duration getExpiryForAccess() {
            return Duration.ZERO;
        }

        public Duration getExpiryForUpdate() {
            return Duration.ZERO;
        }
    }
}

