/*
 * Decompiled with CFR 0.152.
 */
package javax.cache.expiry;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import junit.framework.TestCase;
import org.jsr107.tck.testutil.TestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpiryPolicyTest
extends TestSupport {
    private CacheManager cacheManager;

    @Before
    public void setup() {
        this.cacheManager = Caching.getCachingProvider().getCacheManager();
    }

    @After
    public void cleanupAfterEachTest() throws InterruptedException {
        for (String cacheName : this.cacheManager.getCacheNames()) {
            this.cacheManager.destroyCache(cacheName);
        }
        this.cacheManager.close();
        this.cacheManager = null;
    }

    @Test
    public void testCreatedExpiryPolicy() {
        ExpiryPolicy policy = (ExpiryPolicy)CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, 20L)).create();
        CreatedExpiryPolicy policy2 = new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 20L));
        CreatedExpiryPolicy policy3 = new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 10L));
        TestCase.assertEquals((Object)policy, (Object)policy2);
        Assert.assertNotEquals((Object)policy, (Object)policy3);
        TestCase.assertEquals((int)policy.hashCode(), (int)policy2.hashCode());
        Assert.assertNotEquals((long)policy.hashCode(), (long)policy3.hashCode());
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)policy2)).setStatisticsEnabled(true);
        Cache cache = this.cacheManager.createCache(this.getTestCacheName(), (Configuration)config);
        TestCase.assertEquals((long)20L, (long)policy.getExpiryForCreation().getDurationAmount());
        TestCase.assertNull((Object)policy.getExpiryForAccess());
        TestCase.assertNull((Object)policy.getExpiryForUpdate());
    }

    @Test
    public void testModifiedExpiryPolicy() {
        ModifiedExpiryPolicy policy = new ModifiedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 20L));
        ModifiedExpiryPolicy policy2 = new ModifiedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 20L));
        ModifiedExpiryPolicy policy3 = new ModifiedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 10L));
        TestCase.assertEquals((Object)policy, (Object)policy2);
        Assert.assertNotEquals((Object)policy, (Object)policy3);
        TestCase.assertEquals((int)policy.hashCode(), (int)policy2.hashCode());
        Assert.assertNotEquals((long)policy.hashCode(), (long)policy3.hashCode());
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)policy)).setStatisticsEnabled(true);
        Cache cache = this.cacheManager.createCache(this.getTestCacheName(), (Configuration)config);
        TestCase.assertEquals((long)20L, (long)policy.getExpiryForCreation().getDurationAmount());
        TestCase.assertNull((Object)policy.getExpiryForAccess());
        TestCase.assertEquals((long)20L, (long)policy.getExpiryForUpdate().getDurationAmount());
    }

    @Test
    public void testAccessedExpiryPolicy() {
        AccessedExpiryPolicy policy = new AccessedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 20L));
        AccessedExpiryPolicy policy2 = new AccessedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 20L));
        AccessedExpiryPolicy policy3 = new AccessedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 10L));
        TestCase.assertEquals((Object)policy, (Object)policy2);
        Assert.assertNotEquals((Object)policy, (Object)policy3);
        TestCase.assertEquals((int)policy.hashCode(), (int)policy2.hashCode());
        Assert.assertNotEquals((long)policy.hashCode(), (long)policy3.hashCode());
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)policy)).setStatisticsEnabled(true);
        Cache cache = this.cacheManager.createCache(this.getTestCacheName(), (Configuration)config);
        TestCase.assertEquals((long)20L, (long)policy.getExpiryForCreation().getDurationAmount());
        TestCase.assertEquals((long)20L, (long)policy.getExpiryForAccess().getDurationAmount());
        TestCase.assertNull((Object)policy.getExpiryForUpdate());
    }

    @Test
    public void testTouchedExpiryPolicy() {
        TouchedExpiryPolicy policy = new TouchedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 20L));
        TouchedExpiryPolicy policy2 = new TouchedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 20L));
        TouchedExpiryPolicy policy3 = new TouchedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 10L));
        TestCase.assertEquals((Object)policy, (Object)policy2);
        Assert.assertNotEquals((Object)policy, (Object)policy3);
        TestCase.assertEquals((int)policy.hashCode(), (int)policy2.hashCode());
        Assert.assertNotEquals((long)policy.hashCode(), (long)policy3.hashCode());
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)policy)).setStatisticsEnabled(true);
        Cache cache = this.cacheManager.createCache(this.getTestCacheName(), (Configuration)config);
        TestCase.assertEquals((long)20L, (long)policy.getExpiryForCreation().getDurationAmount());
        TestCase.assertEquals((long)20L, (long)policy.getExpiryForAccess().getDurationAmount());
        TestCase.assertEquals((long)20L, (long)policy.getExpiryForUpdate().getDurationAmount());
    }

    @Test
    public void testEternalExpiryPolicy() {
        EternalExpiryPolicy policy = new EternalExpiryPolicy();
        EternalExpiryPolicy policy2 = new EternalExpiryPolicy();
        TestCase.assertEquals((Object)policy, (Object)policy2);
        TestCase.assertEquals((int)policy.hashCode(), (int)policy2.hashCode());
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)policy)).setStatisticsEnabled(true);
        Cache cache = this.cacheManager.createCache(this.getTestCacheName(), (Configuration)config);
        TestCase.assertEquals((Object)Duration.ETERNAL, (Object)policy.getExpiryForCreation());
        TestCase.assertNull((Object)policy.getExpiryForAccess());
        TestCase.assertNull((Object)policy.getExpiryForUpdate());
    }

    @Test
    public void testEqualsForCreatedExpiryPolicy() {
        ExpiryPolicy policy = (ExpiryPolicy)CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, 20L)).create();
        Assert.assertTrue((boolean)policy.equals(policy));
        Assert.assertFalse((boolean)policy.equals(null));
        Assert.assertFalse((boolean)policy.equals("noMatchWrongClass"));
        ExpiryPolicy nullDurationPolicy = (ExpiryPolicy)CreatedExpiryPolicy.factoryOf(null).create();
        nullDurationPolicy.hashCode();
        Assert.assertFalse((boolean)nullDurationPolicy.equals(policy));
        ExpiryPolicy nullDurationPolicy1 = (ExpiryPolicy)CreatedExpiryPolicy.factoryOf(null).create();
        Assert.assertTrue((boolean)nullDurationPolicy.equals(nullDurationPolicy1));
    }

    @Test
    public void testEqualsForAccessedExpiryPolicy() {
        ExpiryPolicy policy = (ExpiryPolicy)AccessedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, 20L)).create();
        Assert.assertTrue((boolean)policy.equals(policy));
        Assert.assertFalse((boolean)policy.equals(null));
        Assert.assertFalse((boolean)policy.equals("noMatchWrongClass"));
        ExpiryPolicy nullDurationPolicy = (ExpiryPolicy)AccessedExpiryPolicy.factoryOf(null).create();
        nullDurationPolicy.hashCode();
        Assert.assertFalse((boolean)nullDurationPolicy.equals(policy));
        ExpiryPolicy nullDurationPolicy1 = (ExpiryPolicy)AccessedExpiryPolicy.factoryOf(null).create();
        Assert.assertTrue((boolean)nullDurationPolicy.equals(nullDurationPolicy1));
    }

    @Test
    public void testEqualsForModifiedExpiryPolicy() {
        ExpiryPolicy policy = (ExpiryPolicy)ModifiedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, 20L)).create();
        Assert.assertTrue((boolean)policy.equals(policy));
        Assert.assertFalse((boolean)policy.equals(null));
        Assert.assertFalse((boolean)policy.equals("noMatchWrongClass"));
        ExpiryPolicy nullDurationPolicy = (ExpiryPolicy)ModifiedExpiryPolicy.factoryOf(null).create();
        nullDurationPolicy.hashCode();
        Assert.assertFalse((boolean)nullDurationPolicy.equals(policy));
        ExpiryPolicy nullDurationPolicy1 = (ExpiryPolicy)ModifiedExpiryPolicy.factoryOf(null).create();
        Assert.assertTrue((boolean)nullDurationPolicy.equals(nullDurationPolicy1));
    }

    @Test
    public void testEqualsForTouchedExpiryPolicy() {
        ExpiryPolicy policy = (ExpiryPolicy)TouchedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, 20L)).create();
        Assert.assertTrue((boolean)policy.equals(policy));
        Assert.assertFalse((boolean)policy.equals(null));
        Assert.assertFalse((boolean)policy.equals("noMatchWrongClass"));
        ExpiryPolicy nullDurationPolicy = (ExpiryPolicy)TouchedExpiryPolicy.factoryOf(null).create();
        nullDurationPolicy.hashCode();
        Assert.assertFalse((boolean)nullDurationPolicy.equals(policy));
        ExpiryPolicy nullDurationPolicy1 = (ExpiryPolicy)TouchedExpiryPolicy.factoryOf(null).create();
        Assert.assertTrue((boolean)nullDurationPolicy.equals(nullDurationPolicy1));
    }

    @Test
    public void testApplyingMultiplePoliciesToConfiguration() {
        CreatedExpiryPolicy policy = new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 20L));
        CreatedExpiryPolicy policy2 = new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, 10L));
        Assert.assertNotEquals((Object)policy, (Object)policy2);
        MutableConfiguration config = new MutableConfiguration();
        config.setExpiryPolicyFactory(FactoryBuilder.factoryOf((Serializable)policy)).setStatisticsEnabled(true);
        Factory factory2 = FactoryBuilder.factoryOf((Serializable)policy2);
        config.setExpiryPolicyFactory(factory2).setStatisticsEnabled(true);
        TestCase.assertEquals((Object)factory2, (Object)config.getExpiryPolicyFactory());
    }
}

