/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.support;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsr107.tck.support.Operation;
import org.jsr107.tck.support.OperationHandler;

public class Server
implements AutoCloseable {
    public static final Logger LOG = Logger.getLogger(Server.class.getName());
    public static final Operation<Void> CLOSE_OPERATION = new Operation<Void>(){

        @Override
        public String getType() {
            return "CLOSE";
        }

        @Override
        public Void onInvoke(ObjectInputStream ois, ObjectOutputStream oos) throws IOException {
            try {
                ois.readByte();
                throw new IOException("Unexpected data received from the server after close.");
            }
            catch (EOFException eOFException) {
                return null;
            }
        }
    };
    private int port;
    private ConcurrentHashMap<String, OperationHandler> operationHandlers;
    private ServerSocket serverSocket;
    private Thread serverThread;
    private ConcurrentHashMap<Integer, ClientConnection> clientConnections;
    private AtomicBoolean isTerminating;
    private static InetAddress serverSocketAddress = null;

    public Server(int port) {
        this.port = port;
        this.operationHandlers = new ConcurrentHashMap();
        this.serverSocket = null;
        this.serverThread = null;
        this.clientConnections = new ConcurrentHashMap();
        this.isTerminating = new AtomicBoolean(false);
    }

    public void addOperationHandler(OperationHandler handler) {
        this.operationHandlers.put(handler.getType(), handler);
    }

    public synchronized InetAddress open() throws IOException {
        if (this.serverSocket == null) {
            this.serverSocket = this.createServerSocket();
            this.serverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int connectionId = 0;
                        while (!Server.this.isTerminating.get()) {
                            Socket socket = Server.this.serverSocket.accept();
                            ClientConnection clientConnection = new ClientConnection(connectionId++, socket);
                            Server.this.clientConnections.put(clientConnection.getIdentity(), clientConnection);
                            clientConnection.start();
                        }
                    }
                    catch (NullPointerException e) {
                        Server.this.isTerminating.compareAndSet(false, true);
                    }
                    catch (IOException e) {
                        Server.this.isTerminating.compareAndSet(false, true);
                    }
                }
            });
            this.serverThread.start();
        }
        return this.getInetAddress();
    }

    public synchronized InetAddress getInetAddress() {
        if (this.serverSocket != null) {
            try {
                return this.getServerInetAddress();
            }
            catch (SocketException e) {
                return this.serverSocket.getInetAddress();
            }
            catch (UnknownHostException e) {
                return this.serverSocket.getInetAddress();
            }
        }
        throw new IllegalStateException("Server is not open");
    }

    public synchronized int getPort() {
        if (this.serverSocket != null) {
            return this.port;
        }
        throw new IllegalStateException("Server is not open");
    }

    @Override
    public synchronized void close() {
        if (this.serverSocket != null) {
            this.isTerminating.set(true);
            if (this.clientConnections.size() > 0) {
                LOG.warning("Open client connections: " + this.clientConnections);
                throw new IllegalStateException("Expecting no open client connections. Customizations implementing Closeable need to be closed. See https://github.com/jsr107/jsr107tck/issues/100");
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
            this.serverThread.interrupt();
            this.serverThread = null;
            for (ClientConnection clientConnection : this.clientConnections.values()) {
                clientConnection.close();
            }
            this.clientConnections = new ConcurrentHashMap();
            this.isTerminating.set(false);
        }
    }

    private ServerSocket createServerSocket() throws IOException {
        boolean ephemeralPort = false;
        ServerSocket result = null;
        try {
            result = new ServerSocket(this.port, 50, this.getServerInetAddress());
        }
        catch (IOException e) {
            result = new ServerSocket(0, 50, this.getServerInetAddress());
            LOG.warning("createServerSocket: unable to use requested port " + this.port + "; using ephemeral port " + result.getLocalPort());
            this.port = result.getLocalPort();
        }
        LOG.log(Level.INFO, "Starting " + this.getClass().getCanonicalName() + " server at address:" + this.getServerInetAddress() + " port:" + this.port);
        return result;
    }

    private InetAddress getServerInetAddress() throws SocketException, UnknownHostException {
        if (serverSocketAddress == null) {
            boolean preferIPV4Stack = Boolean.getBoolean("java.net.preferIPv4Stack");
            boolean preferIPV6Addresses = Boolean.getBoolean("java.net.preferIPv6Addresses") && !preferIPV4Stack;
            String serverAddress = System.getProperty("org.jsr107.tck.support.server.address");
            if (serverAddress != null) {
                try {
                    serverSocketAddress = InetAddress.getByName(serverAddress);
                }
                catch (UnknownHostException e) {
                    LOG.log(Level.WARNING, "ignoring system property org.jsr107.tck.support.server.address due to exception", e);
                }
            }
            NetworkInterface serverSocketNetworkInterface = null;
            if (serverSocketAddress == null) {
                String niName = System.getProperty("org.jsr107.tck.support.server.networkinterface");
                try {
                    NetworkInterface networkInterface = serverSocketNetworkInterface = niName == null ? null : NetworkInterface.getByName(niName);
                    if (serverSocketNetworkInterface != null) {
                        serverSocketAddress = Server.getFirstNonLoopbackAddress(serverSocketNetworkInterface, preferIPV4Stack, preferIPV6Addresses);
                    }
                    if (serverSocketAddress == null) {
                        LOG.log(Level.WARNING, "ignoring system property org.jsr107.tck.support.server.networkinterface with value:" + niName);
                    }
                }
                catch (SocketException e) {
                    LOG.log(Level.WARNING, "ignoring system property org.jsr107.tck.support.server.networkinterface due to exception", e);
                }
            }
            if (serverSocketAddress == null) {
                serverSocketAddress = Server.getFirstNonLoopbackAddress(preferIPV4Stack, preferIPV6Addresses);
            }
            if (serverSocketAddress == null) {
                LOG.warning("no remote ip address available so only possible to test using loopback address.");
                serverSocketAddress = InetAddress.getLocalHost();
            }
        }
        return serverSocketAddress;
    }

    private static InetAddress getFirstNonLoopbackAddress(boolean preferIPv4, boolean preferIPv6) throws SocketException {
        InetAddress result = null;
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (result == null && en.hasMoreElements()) {
            result = Server.getFirstNonLoopbackAddress(en.nextElement(), preferIPv4, preferIPv6);
        }
        return result;
    }

    private static InetAddress getFirstNonLoopbackAddress(NetworkInterface ni, boolean preferIPv4, boolean preferIPv6) throws SocketException {
        InetAddress result = null;
        if (ni.isVirtual() || ni.isPointToPoint() || !ni.isUp()) {
            return result;
        }
        LOG.info("Interface name is: " + ni.getDisplayName());
        Enumeration<InetAddress> en2 = ni.getInetAddresses();
        while (en2.hasMoreElements()) {
            InetAddress addr = en2.nextElement();
            if (addr.isLoopbackAddress()) continue;
            if (addr instanceof Inet4Address) {
                if (preferIPv6) continue;
                result = addr;
                break;
            }
            if (!(addr instanceof Inet6Address) || preferIPv4) continue;
            result = addr;
            break;
        }
        return result;
    }

    private class ClientConnection
    extends Thread
    implements AutoCloseable {
        private int identity;
        private Socket socket;

        public ClientConnection(int identity, Socket socket) {
            this.identity = identity;
            this.socket = socket;
        }

        public int getIdentity() {
            return this.identity;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block16: {
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(this.socket.getOutputStream());
                    ObjectInputStream ois = new ObjectInputStream(this.socket.getInputStream());
                    while (true) {
                        try {
                            while (true) {
                                String operation = (String)ois.readObject();
                                if (CLOSE_OPERATION.getType().equals(operation)) {
                                    Server.this.clientConnections.remove(this.identity);
                                    this.socket.close();
                                    this.socket = null;
                                    break block16;
                                }
                                OperationHandler handler = (OperationHandler)Server.this.operationHandlers.get(operation);
                                if (handler == null) continue;
                                handler.onProcess(ois, oos);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                }
                finally {
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    Server.this.clientConnections.remove(this.identity);
                }
            }
        }

        @Override
        public void close() {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }
}

