/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.integration;

import javax.cache.Cache;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jsr107.tck.integration.CacheWriterClient;
import org.jsr107.tck.integration.CacheWriterServer;
import org.jsr107.tck.integration.FailingCacheWriter;
import org.jsr107.tck.integration.RecordingCacheWriter;
import org.junit.Assert;
import org.junit.Test;

public class CacheWriterClientServerTest {
    @Test
    public void shouldWriteFromServerWithClient() throws Exception {
        RecordingCacheWriter recordingCacheWriter = new RecordingCacheWriter();
        CacheWriterServer serverCacheWriter = new CacheWriterServer(10000, recordingCacheWriter);
        serverCacheWriter.open();
        CacheWriterClient<String, String> clientCacheWriter = new CacheWriterClient<String, String>(serverCacheWriter.getInetAddress(), serverCacheWriter.getPort());
        Entry<String, String> entry = new Entry<String, String>("hello", "gudday");
        clientCacheWriter.write(entry);
        String writtenValue = (String)recordingCacheWriter.get("hello");
        Assert.assertThat((Object)writtenValue, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)writtenValue, (Matcher)CoreMatchers.is((Object)"gudday"));
        Assert.assertThat((Object)recordingCacheWriter.hasWritten("hello"), (Matcher)CoreMatchers.is((Object)true));
        clientCacheWriter.close();
        serverCacheWriter.close();
    }

    @Test
    public void shouldRethrowExceptions() throws Exception {
        FailingCacheWriter failingCacheWriter = new FailingCacheWriter();
        CacheWriterServer serverCacheWriter = new CacheWriterServer(10000, failingCacheWriter);
        serverCacheWriter.open();
        CacheWriterClient<String, String> clientCacheWriter = new CacheWriterClient<String, String>(serverCacheWriter.getInetAddress(), serverCacheWriter.getPort());
        Entry<String, String> entry = new Entry<String, String>("hello", "gudday");
        try {
            clientCacheWriter.write(entry);
            Assert.fail((String)"An UnsupportedOperationException should have been thrown");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        clientCacheWriter.close();
        serverCacheWriter.close();
    }

    private static class Entry<K, V>
    implements Cache.Entry<K, V> {
        private K key;
        private V value;

        public Entry(K key, V value) {
            this.setKey(key);
            this.setValue(value);
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public <T> T unwrap(Class<T> clazz) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void setKey(K key) {
            this.key = key;
        }

        public void setValue(V value) {
            this.value = value;
        }
    }
}

