/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsr107.tck.support.Operation;

public class Client
implements AutoCloseable {
    private int port;
    private Socket socket;
    private ObjectOutputStream oos;
    private ObjectInputStream ois;

    public Client(InetAddress address, int port) throws IOException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        this.port = port;
        try {
            logger.log(Level.INFO, "Starting " + this.getClass().getCanonicalName() + " client connecting to server at address:" + address + " port:" + port);
            this.socket = new Socket(address, port);
        }
        catch (IOException ioe) {
            throw new IOException("Client failed to connect to server at " + address + ":" + port, ioe);
        }
        this.oos = new ObjectOutputStream(this.socket.getOutputStream());
        this.ois = new ObjectInputStream(this.socket.getInputStream());
    }

    public synchronized <T> T invoke(Operation<T> operation) {
        if (this.socket == null) {
            throw new IllegalStateException("Can't execute an operation as the Client is disconnected");
        }
        try {
            this.oos.writeObject(operation.getType());
            return operation.onInvoke(this.ois, this.oos);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to perform operation " + operation.getType(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.socket != null) {
            try {
                this.oos.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.oos = null;
            }
            try {
                this.ois.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.ois = null;
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }
}

