/*
 * Decompiled with CFR 0.152.
 */
package org.jsr107.tck;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.cache.CacheException;
import javax.cache.Caching;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.configuration.OptionalFeature;
import org.jsr107.tck.testutil.AllTestExcluder;
import org.jsr107.tck.testutil.CacheTestSupport;
import org.jsr107.tck.testutil.ExcludeListExcluder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.MethodRule;

public class StoreByReferenceTest
extends CacheTestSupport<Date, Date> {
    @Rule
    public MethodRule rule = Caching.getCachingProvider().isSupported(OptionalFeature.STORE_BY_REFERENCE) ? new ExcludeListExcluder(this.getClass()) : new AllTestExcluder();

    @Before
    public void moreSetUp() {
        this.cache = this.getCacheManager().getCache(this.getTestCacheName(), Date.class, Date.class);
    }

    @Override
    protected MutableConfiguration<Date, Date> newMutableConfiguration() {
        return new MutableConfiguration().setTypes(Date.class, Date.class);
    }

    @Override
    protected MutableConfiguration<Date, Date> extraSetup(MutableConfiguration<Date, Date> configuration) {
        return super.extraSetup(configuration).setStoreByValue(false);
    }

    @Override
    @After
    public void teardown() {
        try {
            Caching.getCachingProvider().close();
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    @Test
    public void get_Existing() {
        long now = System.currentTimeMillis();
        Date existingKey = new Date(now);
        Date existingValue = new Date(now);
        this.cache.put((Object)existingKey, (Object)existingValue);
        existingValue.setTime(now + 1L);
        Assert.assertSame((Object)existingValue, (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void get_Existing_NotSameKey() {
        long now = System.currentTimeMillis();
        Date existingKey = new Date(now);
        Date existingValue = new Date(now);
        this.cache.put((Object)existingKey, (Object)existingValue);
        existingValue.setTime(now + 1L);
        Assert.assertSame((Object)existingValue, (Object)this.cache.get((Object)new Date(now)));
    }

    @Test
    public void put_Existing_NotSameKey() throws Exception {
        long now = System.currentTimeMillis();
        Date key1 = new Date(now);
        Date value1 = new Date(now);
        this.cache.put((Object)key1, (Object)value1);
        Date key2 = new Date(now);
        Date value2 = new Date(now);
        this.cache.put((Object)key2, (Object)value2);
        value2.setTime(now + 1L);
        Assert.assertSame((Object)value2, (Object)this.cache.get((Object)key2));
    }

    @Test
    public void getAndPut_NotThere() {
        long now = System.currentTimeMillis();
        Date existingKey = new Date(now);
        Date existingValue = new Date(now);
        Assert.assertNull((Object)this.cache.getAndPut((Object)existingKey, (Object)existingValue));
        existingValue.setTime(now + 1L);
        Assert.assertSame((Object)existingValue, (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void getAndPut_Existing() {
        long now = System.currentTimeMillis();
        Date existingKey = new Date(now);
        Date value1 = new Date(now);
        this.cache.getAndPut((Object)existingKey, (Object)value1);
        Date value2 = new Date(now + 1L);
        Assert.assertSame((Object)value1, (Object)this.cache.getAndPut((Object)existingKey, (Object)value2));
        Assert.assertSame((Object)value2, (Object)this.cache.get((Object)existingKey));
    }

    @Test
    public void getAndPut_Existing_NotSameKey() {
        long now = System.currentTimeMillis();
        Date key1 = new Date(now);
        Date value1 = new Date(now);
        this.cache.getAndPut((Object)key1, (Object)value1);
        Date key2 = new Date(now);
        Date value2 = new Date(now + 1L);
        Assert.assertSame((Object)value1, (Object)this.cache.getAndPut((Object)key2, (Object)value2));
        Assert.assertSame((Object)value2, (Object)this.cache.get((Object)key1));
        Assert.assertSame((Object)value2, (Object)this.cache.get((Object)key2));
    }

    @Test
    public void putAll() {
        LinkedHashMap<Date, Date> data = this.createDDData(3);
        this.cache.putAll(data);
        for (Map.Entry entry : data.entrySet()) {
            Assert.assertSame(entry.getValue(), (Object)this.cache.get(entry.getKey()));
        }
    }

    @Test
    public void putIfAbsent_Missing() {
        long now = System.currentTimeMillis();
        Date key = new Date(now);
        Date value = new Date(now);
        Assert.assertTrue((boolean)this.cache.putIfAbsent((Object)key, (Object)value));
        Assert.assertSame((Object)value, (Object)this.cache.get((Object)key));
    }

    @Test
    public void putIfAbsent_There() {
        long now = System.currentTimeMillis();
        Date key = new Date(now);
        Date value = new Date(now);
        Date oldValue = new Date(now + 1L);
        this.cache.put((Object)key, (Object)oldValue);
        Assert.assertFalse((boolean)this.cache.putIfAbsent((Object)key, (Object)value));
        Assert.assertSame((Object)oldValue, (Object)this.cache.get((Object)key));
    }

    @Test
    public void replace_3arg() throws Exception {
        long now = System.currentTimeMillis();
        Date key = new Date(now);
        Date value = new Date(now);
        this.cache.put((Object)key, (Object)value);
        Date nextValue = new Date(now + 1L);
        Assert.assertTrue((boolean)this.cache.replace((Object)key, (Object)value, (Object)nextValue));
        Assert.assertSame((Object)nextValue, (Object)this.cache.get((Object)key));
    }

    @Test
    public void getAndReplace() {
        long now = System.currentTimeMillis();
        Date key = new Date(now);
        Date value = new Date(now);
        this.cache.put((Object)key, (Object)value);
        Date nextValue = new Date(now + 1L);
        Assert.assertSame((Object)value, (Object)this.cache.getAndReplace((Object)key, (Object)nextValue));
        Assert.assertSame((Object)nextValue, (Object)this.cache.get((Object)key));
    }
}

