/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.infinispan.jcache.util.JCacheTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jcache.JCacheExpiryTest")
public class JCacheExpiryTest {
    public void testGetAndReplace(Method m) {
        MutableConfiguration cfg = new MutableConfiguration();
        cfg.setExpiryPolicyFactory((Factory & Serializable)() -> new ExpiryPolicy(){

            public Duration getExpiryForCreation() {
                return Duration.ETERNAL;
            }

            public Duration getExpiryForAccess() {
                return null;
            }

            public Duration getExpiryForUpdate() {
                return Duration.ZERO;
            }
        });
        String name = this.getName(m);
        JCacheTestingUtil.withCachingProvider(provider -> {
            CacheManager cm = provider.getCacheManager();
            Cache cache = cm.createCache(name, (Configuration)cfg);
            cache.put((Object)1, (Object)"v1");
            AssertJUnit.assertTrue((boolean)cache.containsKey((Object)1));
            AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)1)));
            cache.getAndReplace((Object)1, (Object)"v2");
            AssertJUnit.assertFalse((boolean)cache.containsKey((Object)1));
            AssertJUnit.assertNull((Object)cache.get((Object)1));
        });
    }

    private String getName(Method m) {
        return this.getClass().getName() + '.' + m.getName();
    }
}

