/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.GeneratedCacheKey;
import javax.interceptor.InvocationContext;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextImpl;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractCachePutInterceptor
implements Serializable {
    private final CacheResolver cacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    public AbstractCachePutInterceptor(CacheResolver cacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.cacheResolver = cacheResolver;
        this.contextFactory = contextFactory;
    }

    public Object cachePut(InvocationContext invocationContext) throws Exception {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Interception of method named '%s'", (Object)invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContext cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = ((CacheKeyInvocationContextImpl)cacheKeyInvocationContext.unwrap(CacheKeyInvocationContextImpl.class)).getCacheKeyGenerator();
        CachePut cachePut = (CachePut)cacheKeyInvocationContext.getCacheAnnotation();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        Cache cache = this.cacheResolver.resolveCache(cacheKeyInvocationContext);
        Object valueToCache = cacheKeyInvocationContext.getValueParameter().getValue();
        if (!cachePut.afterInvocation() && valueToCache != null) {
            cache.put((Object)cacheKey, valueToCache);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Value '%s' cached in cache '%s' with key '%s' before method invocation", valueToCache, (Object)cache.getName(), (Object)cacheKey);
            }
        }
        Object result = invocationContext.proceed();
        if (cachePut.afterInvocation() && valueToCache != null) {
            cache.put((Object)cacheKey, valueToCache);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Value '%s' cached in cache '%s' with key '%s' after method invocation", valueToCache, (Object)cache.getName(), (Object)cacheKey);
            }
        }
        return result;
    }

    protected abstract Log getLog();
}

