/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.infinispan.jcache.JCacheTestSCI;
import org.infinispan.jcache.embedded.JCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jcache.InvokeProcessorTest")
public class InvokeProcessorTest
extends AbstractInfinispanTest {
    public void testInvokeProcesorStoreByValueException(Method m) {
        this.invokeProcessorThrowsException(m, (MutableConfiguration<String, Entry>)new MutableConfiguration(), new ArrayList<Integer>(Arrays.asList(1, 2, 3)));
    }

    public void testInvokeProcesorStoreByReferenceException(Method m) {
        this.invokeProcessorThrowsException(m, (MutableConfiguration<String, Entry>)new MutableConfiguration().setStoreByValue(false), new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4)));
    }

    public void testInvokeProcesorStoreByValue(Method m) {
        this.invokeProcessor(m, (MutableConfiguration<String, Entry>)new MutableConfiguration());
    }

    private void invokeProcessorThrowsException(Method m, MutableConfiguration<String, Entry> jcacheCfg, List<Integer> expectedValue) {
        String name = this.getName(m);
        JCacheManager cm = new JCacheManager(URI.create(name), TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)JCacheTestSCI.INSTANCE), null);
        Cache cache = cm.createCache(name, jcacheCfg);
        String query = "select * from x";
        cache.put((Object)"select * from x", (Object)new Entry(new ArrayList<Integer>(Arrays.asList(1, 2, 3))));
        try {
            cache.invoke((Object)"select * from x", (EntryProcessor)new TestExceptionThrowingEntryProcessor(), new Object[0]);
            AssertJUnit.fail((String)"Expected an exception to be thrown");
        }
        catch (CacheException e) {
            AssertJUnit.assertTrue((boolean)(e.getCause() instanceof UnexpectedException));
        }
        AssertJUnit.assertEquals(expectedValue, ((Entry)cache.get((Object)"select * from x")).integers);
    }

    private void invokeProcessor(Method m, MutableConfiguration<String, Entry> jcacheCfg) {
        String name = this.getName(m);
        JCacheManager cm = new JCacheManager(URI.create(name), TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)JCacheTestSCI.INSTANCE), null);
        Cache cache = cm.createCache(name, jcacheCfg);
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
        String query = "select * from x";
        cache.put((Object)"select * from x", (Object)new Entry(list));
        cache.invoke((Object)"select * from x", (EntryProcessor)new TestEntryProcessor(), new Object[0]);
        AssertJUnit.assertEquals(new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4)), ((Entry)cache.get((Object)"select * from x")).integers);
    }

    private String getName(Method m) {
        return ((Object)((Object)this)).getClass().getName() + "." + m.getName();
    }

    @ProtoName(value="TestExceptionThrowingEntryProcessor")
    public static class TestExceptionThrowingEntryProcessor
    implements EntryProcessor<String, Entry, Object> {
        public Object process(MutableEntry<String, Entry> entry, Object ... objects) throws EntryProcessorException {
            ((Entry)entry.getValue()).integers.add(4);
            throw new UnexpectedException();
        }
    }

    @ProtoName(value="TestEntryProcessor")
    public static class TestEntryProcessor
    implements EntryProcessor<String, Entry, Object> {
        public Object process(MutableEntry<String, Entry> entry, Object ... objects) throws EntryProcessorException {
            Entry e = (Entry)entry.getValue();
            e.integers.add(4);
            entry.setValue((Object)e);
            return null;
        }
    }

    public static class Entry {
        @ProtoField(number=1, collectionImplementation=ArrayList.class)
        List<Integer> integers;

        @ProtoFactory
        Entry(ArrayList<Integer> integers) {
            this.integers = integers;
        }
    }

    private static class UnexpectedException
    extends RuntimeException {
        private UnexpectedException() {
        }
    }
}

