/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.cache.configuration.MutableConfiguration;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfiguration;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.jcache.embedded.JCacheManager;
import org.infinispan.jcache.util.JCacheTestingUtil;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jcache.JCacheConfigurationTest")
public class JCacheConfigurationTest
extends AbstractInfinispanTest {
    public void testNamedCacheConfiguration() {
        TestingUtil.withCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createCacheManager((boolean)false), cm -> {
            cm.defineConfiguration("oneCache", new ConfigurationBuilder().build());
            JCacheManager jCacheManager = new JCacheManager(URI.create("oneCacheManager"), cm, null);
            AssertJUnit.assertNotNull((Object)jCacheManager.getCache("oneCache"));
        });
    }

    public void testJCacheManagerWherePathContainsFileSchemaAndAbsolutePath() throws Exception {
        URI uri = JCacheConfigurationTest.class.getClassLoader().getResource("infinispan_uri.xml").toURI();
        JCacheTestingUtil.withCachingProvider(provider -> {
            Properties properties = this.getProperties();
            try (JCacheManager jCacheManager = new JCacheManager(uri, provider.getClass().getClassLoader(), provider, properties);){
                javax.cache.Cache cache = jCacheManager.getCache("foo");
                AssertJUnit.assertNotNull((Object)cache);
                AssertJUnit.assertEquals((long)10000L, (long)((AdvancedCache)cache.unwrap(AdvancedCache.class)).getCacheConfiguration().memory().maxCount());
            }
        });
    }

    private Properties getProperties() {
        Properties properties = new Properties();
        properties.put("test.max-count", "10000");
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJCacheManagerWithRealJarFileSchema() throws Exception {
        ClassLoader originalClassLoader;
        block6: {
            File sampleJarWithResourceFile = null;
            originalClassLoader = null;
            try {
                String tmpDir = CommonsTestingUtil.tmpDirectory(JCacheConfigurationTest.class);
                File tmpDirFile = new File(tmpDir);
                if (!tmpDirFile.exists()) {
                    tmpDirFile.mkdirs();
                }
                String sampleJarWithResourcePathString = Paths.get(tmpDir, "sampleJarWithResource.jar").toString();
                sampleJarWithResourceFile = new File(sampleJarWithResourcePathString);
                String existingResourceToAddInJar = "infinispan_uri.xml";
                String targetPathInJar = "sample-dir-inside-jar/";
                this.createJar(sampleJarWithResourceFile, existingResourceToAddInJar, targetPathInJar);
                String fullTargetPath = targetPathInJar + existingResourceToAddInJar;
                originalClassLoader = Thread.currentThread().getContextClassLoader();
                MyClassLoader myClassLoader = new MyClassLoader(new URL[0], originalClassLoader);
                myClassLoader.addURL(new URI("jar:" + sampleJarWithResourceFile.toURI() + "!/").toURL());
                Thread.currentThread().setContextClassLoader(myClassLoader);
                URI resourceInsideJarUri = new URI("jar:" + sampleJarWithResourceFile.toURI() + "!" + fullTargetPath);
                JCacheTestingUtil.withCachingProvider(provider -> {
                    try (JCacheManager jCacheManager = new JCacheManager(resourceInsideJarUri, provider.getClass().getClassLoader(), provider, this.getProperties());){
                        AssertJUnit.assertNotNull((Object)jCacheManager.getCache("foo"));
                    }
                });
                if (sampleJarWithResourceFile == null || !sampleJarWithResourceFile.exists()) break block6;
                sampleJarWithResourceFile.delete();
            }
            catch (Throwable throwable) {
                if (sampleJarWithResourceFile != null && sampleJarWithResourceFile.exists()) {
                    sampleJarWithResourceFile.delete();
                }
                if (originalClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(originalClassLoader);
                }
                throw throwable;
            }
        }
        if (originalClassLoader != null) {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void createJar(File jarFile, String existingResourceToAddInJar, String targetPathInJar) throws IOException, URISyntaxException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        JarOutputStream sampleJarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);
        URI contentFileUri = Objects.requireNonNull(JCacheConfigurationTest.class.getClassLoader().getResource(existingResourceToAddInJar)).toURI();
        File contentFile = new File(contentFileUri);
        String fullTargetPath = targetPathInJar + contentFile.getName();
        this.addInJar(new File(contentFileUri), fullTargetPath, sampleJarOutputStream);
        sampleJarOutputStream.close();
    }

    public void testJCacheManagerWithWildcardCacheConfigurations() throws Exception {
        URI uri = JCacheConfigurationTest.class.getClassLoader().getResource("infinispan_uri.xml").toURI();
        JCacheTestingUtil.withCachingProvider(provider -> {
            try (JCacheManager jCacheManager = new JCacheManager(uri, provider.getClass().getClassLoader(), provider, this.getProperties());){
                javax.cache.Cache wildcache1 = jCacheManager.createCache("wildcache1", (javax.cache.configuration.Configuration)new MutableConfiguration());
                Cache unwrap = (Cache)wildcache1.unwrap(Cache.class);
                Configuration configuration = unwrap.getCacheConfiguration();
                AssertJUnit.assertEquals((long)10500L, (long)configuration.expiration().wakeUpInterval());
                AssertJUnit.assertEquals((long)11L, (long)configuration.expiration().lifespan());
                AssertJUnit.assertEquals((long)11L, (long)configuration.expiration().maxIdle());
            }
        });
    }

    private void addInJar(File contentFile, String targetFilePath, JarOutputStream jarOutputStream) throws IOException {
        if (contentFile.isDirectory()) {
            return;
        }
        JarEntry jarEntry = new JarEntry(targetFilePath.replace("\\", "/"));
        jarOutputStream.putNextEntry(jarEntry);
        jarEntry.setTime(contentFile.lastModified());
        try (BufferedInputStream contentFileBufferedInputStream = new BufferedInputStream(new FileInputStream(contentFile));){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = contentFileBufferedInputStream.read(buffer)) != -1) {
                jarOutputStream.write(buffer, 0, count);
            }
            jarOutputStream.closeEntry();
        }
    }

    public void testProgrammaticGlobalConfiguration() throws Exception {
        URI uri = JCacheConfigurationTest.class.getClassLoader().getResource("infinispan_uri.xml").toURI();
        Properties properties = this.getProperties();
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.addModule(PrivateGlobalConfigurationBuilder.class);
        properties.put(GlobalConfigurationBuilder.class.getName(), global);
        JCacheTestingUtil.withCachingProvider(provider -> {
            try (JCacheManager jCacheManager = new JCacheManager(uri, provider.getClass().getClassLoader(), provider, properties);){
                DefaultCacheManager defaultCacheManager = (DefaultCacheManager)jCacheManager.unwrap(DefaultCacheManager.class);
                AssertJUnit.assertNotNull((Object)defaultCacheManager.getCacheManagerConfiguration().module(PrivateGlobalConfiguration.class));
            }
        });
    }

    public void testProgrammaticConfigurationHolder() throws Exception {
        URI uri = JCacheConfigurationTest.class.getClassLoader().getResource("infinispan_uri.xml").toURI();
        Properties properties = this.getProperties();
        ConfigurationBuilderHolder cbh = new ConfigurationBuilderHolder();
        cbh.getGlobalConfigurationBuilder().addModule(PrivateGlobalConfigurationBuilder.class);
        properties.put(ConfigurationBuilderHolder.class.getName(), cbh);
        JCacheTestingUtil.withCachingProvider(provider -> {
            try (JCacheManager jCacheManager = new JCacheManager(uri, provider.getClass().getClassLoader(), provider, properties);){
                DefaultCacheManager defaultCacheManager = (DefaultCacheManager)jCacheManager.unwrap(DefaultCacheManager.class);
                AssertJUnit.assertNotNull((Object)defaultCacheManager.getCacheManagerConfiguration().module(PrivateGlobalConfiguration.class));
            }
        });
    }

    public void testProgrammaticCacheConfiguration() throws Exception {
        URI uri = JCacheConfigurationTest.class.getClassLoader().getResource("infinispan_uri.xml").toURI();
        Properties properties = this.getProperties();
        Function<String, Configuration> f = s -> new ConfigurationBuilder().memory().maxCount(1234L).build();
        properties.put(JCacheManager.CACHE_CONFIGURATION_FUNCTION, f);
        JCacheTestingUtil.withCachingProvider(provider -> {
            try (JCacheManager jCacheManager = new JCacheManager(uri, provider.getClass().getClassLoader(), provider, properties);){
                javax.cache.Cache cache = jCacheManager.createCache("cache", (javax.cache.configuration.Configuration)new MutableConfiguration());
                Cache unwrap = (Cache)cache.unwrap(Cache.class);
                Configuration configuration = unwrap.getCacheConfiguration();
                AssertJUnit.assertEquals((long)1234L, (long)configuration.memory().maxCount());
            }
        });
    }

    public class MyClassLoader
    extends URLClassLoader {
        MyClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        @Override
        public URL getResource(String name) {
            return super.getResource(name);
        }
    }
}

