/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.cache.Cache;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerRegistration;
import javax.cache.event.CacheEntryReadListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import org.infinispan.jcache.JCacheEventFilteringIterable;
import org.infinispan.jcache.RICacheEntryEvent;
import org.infinispan.jcache.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JCacheNotifier<K, V> {
    private static final Log log = (Log)LogFactory.getLog(JCacheNotifier.class, Log.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final List<CacheEntryListenerRegistration<? super K, ? super V>> createdListeners = new CopyOnWriteArrayList<CacheEntryListenerRegistration<? super K, ? super V>>();
    private final List<CacheEntryListenerRegistration<? super K, ? super V>> updatedListeners = new CopyOnWriteArrayList<CacheEntryListenerRegistration<? super K, ? super V>>();
    private final List<CacheEntryListenerRegistration<? super K, ? super V>> removedListeners = new CopyOnWriteArrayList<CacheEntryListenerRegistration<? super K, ? super V>>();
    private final List<CacheEntryListenerRegistration<? super K, ? super V>> readListeners = new CopyOnWriteArrayList<CacheEntryListenerRegistration<? super K, ? super V>>();
    private final List<CacheEntryListenerRegistration<? super K, ? super V>> expiredListeners = new CopyOnWriteArrayList<CacheEntryListenerRegistration<? super K, ? super V>>();

    public void addListener(CacheEntryListenerRegistration<? super K, ? super V> reg) {
        this.addListener(reg, false);
    }

    public boolean addListenerIfAbsent(CacheEntryListenerRegistration<? super K, ? super V> reg) {
        return this.addListener(reg, true);
    }

    public boolean removeListener(CacheEntryListener<?, ?> listener) {
        boolean removed = false;
        if (listener instanceof CacheEntryCreatedListener) {
            removed = this.removeListener(listener, this.createdListeners);
        }
        if (listener instanceof CacheEntryUpdatedListener) {
            removed = this.removeListener(listener, this.updatedListeners);
        }
        if (listener instanceof CacheEntryRemovedListener) {
            removed = this.removeListener(listener, this.removedListeners);
        }
        if (listener instanceof CacheEntryReadListener) {
            removed = this.removeListener(listener, this.readListeners);
        }
        if (listener instanceof CacheEntryExpiredListener) {
            removed = this.removeListener(listener, this.expiredListeners);
        }
        return removed;
    }

    public void notifyEntryCreated(Cache<K, V> cache, K key, V value) {
        if (!this.createdListeners.isEmpty()) {
            List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value);
            for (CacheEntryListenerRegistration<? super K, ? super V> cacheEntryListenerRegistration : this.createdListeners) {
                ((CacheEntryCreatedListener)cacheEntryListenerRegistration.getCacheEntryListener()).onCreated(this.getEntryIterable(events, cacheEntryListenerRegistration));
            }
        }
    }

    public void notifyEntryUpdated(Cache<K, V> cache, K key, V value) {
        if (!this.updatedListeners.isEmpty()) {
            List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value);
            for (CacheEntryListenerRegistration<? super K, ? super V> cacheEntryListenerRegistration : this.updatedListeners) {
                CacheEntryUpdatedListener listener = (CacheEntryUpdatedListener)cacheEntryListenerRegistration.getCacheEntryListener();
                listener.onUpdated(this.getEntryIterable(events, cacheEntryListenerRegistration));
            }
        }
    }

    public void notifyEntryRemoved(Cache<K, V> cache, K key, V value) {
        if (!this.removedListeners.isEmpty()) {
            List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value);
            for (CacheEntryListenerRegistration<? super K, ? super V> cacheEntryListenerRegistration : this.removedListeners) {
                ((CacheEntryRemovedListener)cacheEntryListenerRegistration.getCacheEntryListener()).onRemoved(this.getEntryIterable(events, cacheEntryListenerRegistration));
            }
        }
    }

    public void notifyEntryRead(Cache<K, V> cache, K key, V value) {
        if (!this.readListeners.isEmpty()) {
            List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value);
            for (CacheEntryListenerRegistration<? super K, ? super V> cacheEntryListenerRegistration : this.readListeners) {
                ((CacheEntryReadListener)cacheEntryListenerRegistration.getCacheEntryListener()).onRead(this.getEntryIterable(events, cacheEntryListenerRegistration));
            }
        }
    }

    public void notifyEntryExpired(Cache<K, V> cache, K key, V value) {
        if (!this.expiredListeners.isEmpty()) {
            List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value);
            for (CacheEntryListenerRegistration<? super K, ? super V> cacheEntryListenerRegistration : this.expiredListeners) {
                ((CacheEntryExpiredListener)cacheEntryListenerRegistration.getCacheEntryListener()).onExpired(this.getEntryIterable(events, cacheEntryListenerRegistration));
            }
        }
    }

    private Iterable<CacheEntryEvent<? extends K, ? extends V>> getEntryIterable(List<CacheEntryEvent<? extends K, ? extends V>> events, CacheEntryListenerRegistration<? super K, ? super V> reg) {
        CacheEntryEventFilter filter = reg.getCacheEntryFilter();
        return filter == null ? events : new JCacheEventFilteringIterable<K, V>(events, filter);
    }

    private boolean addListener(CacheEntryListenerRegistration<? super K, ? super V> reg, boolean addIfAbsent) {
        boolean added = false;
        CacheEntryListener listener = reg.getCacheEntryListener();
        if (listener instanceof CacheEntryCreatedListener) {
            added = this.addListener(addIfAbsent, reg, listener, this.createdListeners);
        }
        if (listener instanceof CacheEntryUpdatedListener) {
            added = this.addListener(addIfAbsent, reg, listener, this.updatedListeners);
        }
        if (listener instanceof CacheEntryRemovedListener) {
            added = this.addListener(addIfAbsent, reg, listener, this.removedListeners);
        }
        if (listener instanceof CacheEntryReadListener) {
            added = this.addListener(addIfAbsent, reg, listener, this.readListeners);
        }
        if (listener instanceof CacheEntryExpiredListener) {
            added = this.addListener(addIfAbsent, reg, listener, this.expiredListeners);
        }
        return added;
    }

    private boolean addListener(boolean addIfAbsent, CacheEntryListenerRegistration<? super K, ? super V> reg, CacheEntryListener<? super K, ? super V> listener, List<CacheEntryListenerRegistration<? super K, ? super V>> listeners) {
        return !this.containsListener(addIfAbsent, listener, listeners) && listeners.add(reg);
    }

    private boolean containsListener(boolean addIfAbsent, CacheEntryListener<? super K, ? super V> listener, List<CacheEntryListenerRegistration<? super K, ? super V>> listeners) {
        if (addIfAbsent) {
            for (CacheEntryListenerRegistration<K, V> cacheEntryListenerRegistration : listeners) {
                if (!cacheEntryListenerRegistration.getCacheEntryListener().equals(listener)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean removeListener(CacheEntryListener<?, ?> listener, List<CacheEntryListenerRegistration<? super K, ? super V>> listeners) {
        for (CacheEntryListenerRegistration<K, V> cacheEntryListenerRegistration : listeners) {
            if (!cacheEntryListenerRegistration.getCacheEntryListener().equals(listener)) continue;
            return listeners.remove(cacheEntryListenerRegistration);
        }
        return false;
    }

    private List<CacheEntryEvent<? extends K, ? extends V>> createEvent(Cache<K, V> cache, K key, V value) {
        List<CacheEntryEvent<? extends K, ? extends V>> events = Collections.singletonList(new RICacheEntryEvent<K, V>(cache, key, value));
        if (isTrace) {
            log.tracef("Received event: %s", events);
        }
        return events;
    }
}

