/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.GeneratedCacheKey;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.infinispan.jcache.annotation.CacheLookupHelper;
import org.infinispan.jcache.annotation.DefaultCacheKeyGenerator;
import org.infinispan.jcache.util.Deployments;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="cdi.test.util.CacheLookupHelperTest")
public class CacheLookupHelperTest
extends Arquillian {
    @Inject
    private BeanManager beanManager;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)Deployments.baseDeployment().addClass(CacheLookupHelperTest.class)).addClass(Foo.class)).addClass(Bar.class)).addClass(FooCacheKeyGenerator.class)).addClass(BarCacheKeyGenerator.class);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="method parameter must not be null")
    public void testGetCacheNameWithNullMethodParameter() {
        CacheLookupHelper.getCacheName(null, (String)"", null, (boolean)false);
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="methodCacheName parameter must not be null")
    public void testGetCacheNameWithNullMethodCacheNameParameter() throws Exception {
        Method fooMethod = Foo.class.getMethod("fooMethod", String.class, String.class);
        CacheLookupHelper.getCacheName((Method)fooMethod, null, null, (boolean)false);
    }

    public void testGetCacheNameWithMethodCacheNameWithoutDefaultAnnotation() throws Exception {
        Method barMethod = Foo.class.getMethod("barMethod", new Class[0]);
        CacheResult cacheResultAnnotation = barMethod.getAnnotation(CacheResult.class);
        String cacheName = CacheLookupHelper.getCacheName((Method)barMethod, (String)cacheResultAnnotation.cacheName(), null, (boolean)false);
        Assert.assertEquals((String)cacheName, (String)"bar-cache");
    }

    public void testGetCacheNameWithoutMethodCacheNameWithoutDefaultAnnotation() throws Exception {
        Method fooMethod = Foo.class.getMethod("fooMethod", String.class, String.class);
        CacheResult cacheResultAnnotation = fooMethod.getAnnotation(CacheResult.class);
        String cacheName = CacheLookupHelper.getCacheName((Method)fooMethod, (String)cacheResultAnnotation.cacheName(), null, (boolean)false);
        Assert.assertEquals((String)cacheName, (String)"");
    }

    public void testGetCacheNameWithoutMethodCacheNameWithoutDefaultAndGenerate() throws Exception {
        Method fooMethod = Foo.class.getMethod("fooMethod", String.class, String.class);
        CacheResult cacheResultAnnotation = fooMethod.getAnnotation(CacheResult.class);
        String cacheName = CacheLookupHelper.getCacheName((Method)fooMethod, (String)cacheResultAnnotation.cacheName(), null, (boolean)true);
        Assert.assertEquals((String)cacheName, (String)(Foo.class.getName() + ".fooMethod(java.lang.String,java.lang.String)"));
    }

    public void testGetCacheNameWithoutMethodCacheNameAndDefault() throws Exception {
        Method fooMethod = Foo.class.getMethod("fooMethod", String.class, String.class);
        CacheResult cacheResultAnnotation = fooMethod.getAnnotation(CacheResult.class);
        CacheDefaults cacheDefaultsAnnotation = Foo.class.getAnnotation(CacheDefaults.class);
        String cacheName = CacheLookupHelper.getCacheName((Method)fooMethod, (String)cacheResultAnnotation.cacheName(), (CacheDefaults)cacheDefaultsAnnotation, (boolean)false);
        Assert.assertEquals((String)cacheName, (String)"default-cache");
    }

    public void testGetCacheNameWithMethodCacheNameAndDefault() throws Exception {
        Method barMethod = Foo.class.getMethod("barMethod", new Class[0]);
        CacheResult cacheResultAnnotation = barMethod.getAnnotation(CacheResult.class);
        CacheDefaults cacheDefaultsAnnotation = Foo.class.getAnnotation(CacheDefaults.class);
        String cacheName = CacheLookupHelper.getCacheName((Method)barMethod, (String)cacheResultAnnotation.cacheName(), (CacheDefaults)cacheDefaultsAnnotation, (boolean)false);
        Assert.assertEquals((String)cacheName, (String)"bar-cache");
    }

    public void testGetCacheNameWithoutMethodCacheNameWithoutDefault() throws Exception {
        Method fooMethod = Bar.class.getMethod("fooMethod", new Class[0]);
        CacheResult cacheResultAnnotation = fooMethod.getAnnotation(CacheResult.class);
        CacheDefaults cacheDefaultsAnnotation = Bar.class.getAnnotation(CacheDefaults.class);
        String cacheName = CacheLookupHelper.getCacheName((Method)fooMethod, (String)cacheResultAnnotation.cacheName(), (CacheDefaults)cacheDefaultsAnnotation, (boolean)false);
        Assert.assertEquals((String)cacheName, (String)"");
    }

    public void testGetCacheNameWithMethodCacheNameWithoutDefault() throws Exception {
        Method barMethod = Bar.class.getMethod("barMethod", new Class[0]);
        CacheResult cacheResultAnnotation = barMethod.getAnnotation(CacheResult.class);
        CacheDefaults cacheDefaultsAnnotation = Bar.class.getAnnotation(CacheDefaults.class);
        String cacheName = CacheLookupHelper.getCacheName((Method)barMethod, (String)cacheResultAnnotation.cacheName(), (CacheDefaults)cacheDefaultsAnnotation, (boolean)false);
        Assert.assertEquals((String)cacheName, (String)"bar-cache");
    }

    @Test(expectedExceptions={NullPointerException.class}, expectedExceptionsMessageRegExp="beanManager parameter must not be null")
    public void testGetCacheKeyGeneratorWithNullBeanManagerParameter() {
        CacheLookupHelper.getCacheKeyGenerator(null, null, null);
    }

    public void testGetCacheKeyGeneratorWithoutMethodCacheKeyGeneratorWithoutDefaultAnnotation() throws Exception {
        Method fooMethod = Foo.class.getMethod("fooMethod", String.class, String.class);
        CacheResult cacheResultAnnotation = fooMethod.getAnnotation(CacheResult.class);
        CacheKeyGenerator cacheKeyGenerator = CacheLookupHelper.getCacheKeyGenerator((BeanManager)this.beanManager, (Class)cacheResultAnnotation.cacheKeyGenerator(), null);
        Assert.assertTrue((boolean)(cacheKeyGenerator instanceof DefaultCacheKeyGenerator));
    }

    public void testGetCacheKeyGeneratorWithoutMethodCacheKeyGeneratorAndDefault() throws Exception {
        Method fooMethod = Foo.class.getMethod("fooMethod", String.class, String.class);
        CacheResult cacheResultAnnotation = fooMethod.getAnnotation(CacheResult.class);
        CacheDefaults cacheDefaultsAnnotation = Foo.class.getAnnotation(CacheDefaults.class);
        CacheKeyGenerator cacheKeyGenerator = CacheLookupHelper.getCacheKeyGenerator((BeanManager)this.beanManager, (Class)cacheResultAnnotation.cacheKeyGenerator(), (CacheDefaults)cacheDefaultsAnnotation);
        Assert.assertTrue((boolean)(cacheKeyGenerator instanceof FooCacheKeyGenerator));
    }

    public void testCacheKeyGeneratorWithMethodCacheKeyGeneratorAndDefault() throws Exception {
        Method barMethod = Foo.class.getMethod("barMethod", new Class[0]);
        CacheResult cacheResultAnnotation = barMethod.getAnnotation(CacheResult.class);
        CacheDefaults cacheDefaultsAnnotation = Foo.class.getAnnotation(CacheDefaults.class);
        CacheKeyGenerator cacheKeyGenerator = CacheLookupHelper.getCacheKeyGenerator((BeanManager)this.beanManager, (Class)cacheResultAnnotation.cacheKeyGenerator(), (CacheDefaults)cacheDefaultsAnnotation);
        Assert.assertTrue((boolean)(cacheKeyGenerator instanceof BarCacheKeyGenerator));
    }

    public void testCacheKeyGeneratorNameWithoutMethodCacheKeyGeneratorWithoutDefault() throws Exception {
        Method fooMethod = Bar.class.getMethod("fooMethod", new Class[0]);
        CacheResult cacheResultAnnotation = fooMethod.getAnnotation(CacheResult.class);
        CacheDefaults cacheDefaultsAnnotation = Bar.class.getAnnotation(CacheDefaults.class);
        CacheKeyGenerator cacheKeyGenerator = CacheLookupHelper.getCacheKeyGenerator((BeanManager)this.beanManager, (Class)cacheResultAnnotation.cacheKeyGenerator(), (CacheDefaults)cacheDefaultsAnnotation);
        Assert.assertTrue((boolean)(cacheKeyGenerator instanceof DefaultCacheKeyGenerator));
    }

    public void testGetCacheKeyGeneratorWithMethodCacheKeyGeneratorWithoutDefault() throws Exception {
        Method barMethod = Bar.class.getMethod("barMethod", new Class[0]);
        CacheResult cacheResultAnnotation = barMethod.getAnnotation(CacheResult.class);
        CacheDefaults cacheDefaultsAnnotation = Bar.class.getAnnotation(CacheDefaults.class);
        CacheKeyGenerator cacheKeyGenerator = CacheLookupHelper.getCacheKeyGenerator((BeanManager)this.beanManager, (Class)cacheResultAnnotation.cacheKeyGenerator(), (CacheDefaults)cacheDefaultsAnnotation);
        Assert.assertTrue((boolean)(cacheKeyGenerator instanceof BarCacheKeyGenerator));
    }

    public void testGetCacheKeyGeneratorWithANonManagedCacheKeyGenerator() throws Exception {
        Method bazMethod = Foo.class.getMethod("bazMethod", new Class[0]);
        CacheResult cacheResultAnnotation = bazMethod.getAnnotation(CacheResult.class);
        CacheDefaults cacheDefaultsAnnotation = Bar.class.getAnnotation(CacheDefaults.class);
        CacheKeyGenerator cacheKeyGenerator = CacheLookupHelper.getCacheKeyGenerator((BeanManager)this.beanManager, (Class)cacheResultAnnotation.cacheKeyGenerator(), (CacheDefaults)cacheDefaultsAnnotation);
        Assert.assertTrue((boolean)(cacheKeyGenerator instanceof BazCacheKeyGenerator));
    }

    static class BazCacheKeyGenerator
    implements CacheKeyGenerator {
        BazCacheKeyGenerator() {
        }

        public GeneratedCacheKey generateCacheKey(CacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext) {
            return null;
        }
    }

    static class BarCacheKeyGenerator
    implements CacheKeyGenerator {
        BarCacheKeyGenerator() {
        }

        public GeneratedCacheKey generateCacheKey(CacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext) {
            return null;
        }
    }

    static class FooCacheKeyGenerator
    implements CacheKeyGenerator {
        FooCacheKeyGenerator() {
        }

        public GeneratedCacheKey generateCacheKey(CacheKeyInvocationContext<? extends Annotation> cacheKeyInvocationContext) {
            return null;
        }
    }

    @CacheDefaults
    static class Bar {
        Bar() {
        }

        @CacheResult
        public void fooMethod() {
        }

        @CacheResult(cacheName="bar-cache", cacheKeyGenerator=BarCacheKeyGenerator.class)
        public void barMethod() {
        }
    }

    @CacheDefaults(cacheName="default-cache", cacheKeyGenerator=FooCacheKeyGenerator.class)
    static class Foo {
        Foo() {
        }

        @CacheResult
        public String fooMethod(String foo, String foo2) {
            return foo + foo2;
        }

        @CacheResult(cacheName="bar-cache", cacheKeyGenerator=BarCacheKeyGenerator.class)
        public void barMethod() {
        }

        @CacheResult(cacheKeyGenerator=BazCacheKeyGenerator.class)
        public void bazMethod() {
        }
    }
}

