/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.jcache.JCacheEventFilteringIterable;
import org.infinispan.jcache.RICacheEntryEvent;
import org.infinispan.jcache.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JCacheNotifier<K, V> {
    private static final Log log = (Log)LogFactory.getLog(JCacheNotifier.class, Log.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final List<CacheEntryCreatedListener<K, V>> createdListeners = new CopyOnWriteArrayList<CacheEntryCreatedListener<K, V>>();
    private final List<CacheEntryUpdatedListener<K, V>> updatedListeners = new CopyOnWriteArrayList<CacheEntryUpdatedListener<K, V>>();
    private final List<CacheEntryRemovedListener<K, V>> removedListeners = new CopyOnWriteArrayList<CacheEntryRemovedListener<K, V>>();
    private final List<CacheEntryExpiredListener<K, V>> expiredListeners = new CopyOnWriteArrayList<CacheEntryExpiredListener<K, V>>();
    private final ConcurrentMap<CacheEntryListener<? super K, ? super V>, CacheEntryListenerConfiguration<K, V>> listenerCfgs = CollectionFactory.makeConcurrentMap();

    public void addListener(CacheEntryListenerConfiguration<K, V> reg) {
        this.addListener(reg, false);
    }

    public void notifyEntryCreated(Cache<K, V> cache, K key, V value) {
        if (!this.createdListeners.isEmpty()) {
            List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value, EventType.CREATED);
            for (CacheEntryCreatedListener<K, V> listener : this.createdListeners) {
                listener.onCreated(this.getEntryIterable(events, (CacheEntryListenerConfiguration)this.listenerCfgs.get(listener)));
            }
        }
    }

    public void notifyEntryUpdated(Cache<K, V> cache, K key, V value) {
        if (!this.updatedListeners.isEmpty()) {
            List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value, EventType.UPDATED);
            for (CacheEntryUpdatedListener<K, V> listener : this.updatedListeners) {
                listener.onUpdated(this.getEntryIterable(events, (CacheEntryListenerConfiguration)this.listenerCfgs.get(listener)));
            }
        }
    }

    public void notifyEntryRemoved(Cache<K, V> cache, K key, V value) {
        if (!this.removedListeners.isEmpty()) {
            List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value, EventType.REMOVED);
            for (CacheEntryRemovedListener<K, V> listener : this.removedListeners) {
                listener.onRemoved(this.getEntryIterable(events, (CacheEntryListenerConfiguration)this.listenerCfgs.get(listener)));
            }
        }
    }

    public void notifyEntryExpired(Cache<K, V> cache, K key, V value) {
        if (!this.expiredListeners.isEmpty()) {
            List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value, EventType.EXPIRED);
            for (CacheEntryExpiredListener<K, V> listener : this.expiredListeners) {
                listener.onExpired(this.getEntryIterable(events, (CacheEntryListenerConfiguration)this.listenerCfgs.get(listener)));
            }
        }
    }

    private Iterable<CacheEntryEvent<? extends K, ? extends V>> getEntryIterable(List<CacheEntryEvent<? extends K, ? extends V>> events, CacheEntryListenerConfiguration<K, V> listenerCfg) {
        Factory factory = listenerCfg.getCacheEntryEventFilterFactory();
        if (factory != null) {
            CacheEntryEventFilter filter = (CacheEntryEventFilter)factory.create();
            return filter == null ? events : new JCacheEventFilteringIterable<K, V>(events, filter);
        }
        return events;
    }

    private boolean addListener(CacheEntryListenerConfiguration<K, V> listenerCfg, boolean addIfAbsent) {
        boolean added = false;
        CacheEntryListener listener = (CacheEntryListener)listenerCfg.getCacheEntryListenerFactory().create();
        if (listener instanceof CacheEntryCreatedListener) {
            boolean bl = added = !this.containsListener(addIfAbsent, listener, this.createdListeners) && this.createdListeners.add((CacheEntryCreatedListener)listener);
        }
        if (listener instanceof CacheEntryUpdatedListener) {
            boolean bl = added = !this.containsListener(addIfAbsent, listener, this.updatedListeners) && this.updatedListeners.add((CacheEntryUpdatedListener)listener);
        }
        if (listener instanceof CacheEntryRemovedListener) {
            boolean bl = added = !this.containsListener(addIfAbsent, listener, this.removedListeners) && this.removedListeners.add((CacheEntryRemovedListener)listener);
        }
        if (listener instanceof CacheEntryExpiredListener) {
            boolean bl = added = !this.containsListener(addIfAbsent, listener, this.expiredListeners) && this.expiredListeners.add((CacheEntryExpiredListener)listener);
        }
        if (added) {
            this.listenerCfgs.put(listener, listenerCfg);
        }
        return added;
    }

    private boolean containsListener(boolean addIfAbsent, CacheEntryListener<? super K, ? super V> listenerToAdd, List<? extends CacheEntryListener<? super K, ? super V>> listeners) {
        if (addIfAbsent) {
            for (CacheEntryListener<K, V> listener : listeners) {
                if (!listener.equals(listenerToAdd)) continue;
                return true;
            }
        }
        return false;
    }

    private List<CacheEntryEvent<? extends K, ? extends V>> createEvent(Cache<K, V> cache, K key, V value, EventType eventType) {
        List<CacheEntryEvent<? extends K, ? extends V>> events = Collections.singletonList(new RICacheEntryEvent<K, V>(cache, key, value, eventType));
        if (isTrace) {
            log.tracef("Received event: %s", events);
        }
        return events;
    }
}

