/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.Cache;
import org.infinispan.jcache.JCacheNotifier;
import org.infinispan.jcache.logging.Log;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.util.logging.LogFactory;

@Listener
public class JCacheListenerAdapter<K, V> {
    private static final Log log = (Log)LogFactory.getLog(JCacheListenerAdapter.class, Log.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final Cache<K, V> cache;
    private final JCacheNotifier<K, V> notifier;

    public JCacheListenerAdapter(Cache<K, V> cache, JCacheNotifier<K, V> notifier) {
        this.cache = cache;
        this.notifier = notifier;
    }

    @CacheEntryCreated
    public void handleCacheEntryCreatedEvent(CacheEntryCreatedEvent<K, V> e) {
        if (!e.isPre()) {
            this.notifier.notifyEntryCreated(this.cache, e.getKey(), e.getValue());
        }
    }

    @CacheEntryModified
    public void handleCacheEntryModifiedEvent(CacheEntryModifiedEvent<K, V> e) {
        if (!e.isPre() && !e.isCreated()) {
            this.notifier.notifyEntryUpdated(this.cache, e.getKey(), e.getValue());
        }
    }

    @CacheEntryRemoved
    public void handleCacheEntryRemovedEvent(CacheEntryRemovedEvent<K, V> e) {
        if (!e.isPre()) {
            this.notifier.notifyEntryRemoved(this.cache, e.getKey(), e.getOldValue());
        }
    }
}

