/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import org.infinispan.jcache.Exceptions;
import org.infinispan.jcache.JCacheEntry;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.InitializationContext;

public class JCacheWriterAdapter<K, V>
implements CacheWriter {
    private javax.cache.integration.CacheWriter<? super K, ? super V> delegate;

    public void setCacheWriter(javax.cache.integration.CacheWriter<? super K, ? super V> delegate) {
        this.delegate = delegate;
    }

    public void init(InitializationContext ctx) {
    }

    public void write(MarshalledEntry entry) {
        try {
            this.delegate.write(new JCacheEntry<Object, Object>(entry.getKey(), entry.getValue()));
        }
        catch (Exception e) {
            throw Exceptions.launderCacheWriterException(e);
        }
    }

    public boolean delete(Object key) {
        try {
            this.delegate.delete(key);
        }
        catch (Exception e) {
            throw Exceptions.launderCacheWriterException(e);
        }
        return false;
    }

    public void start() {
    }

    public void stop() {
    }
}

