/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jcache.ConfigurationAdapter;
import org.infinispan.jcache.JCache;
import org.infinispan.jcache.RIMBeanServerRegistrationUtility;
import org.infinispan.jcache.logging.Log;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.LogFactory;

public class JCacheManager
implements CacheManager {
    private static final Log log = (Log)LogFactory.getLog(JCacheManager.class, Log.class);
    private final HashMap<String, JCache<?, ?>> caches = new HashMap();
    private final URI uri;
    private final EmbeddedCacheManager cm;
    private final CachingProvider provider;
    private final StackTraceElement[] allocationStackTrace = Thread.currentThread().getStackTrace();
    private final Properties properties;
    private final boolean managedCacheManager;
    private volatile boolean isClosed;

    public JCacheManager(URI uri, ClassLoader classLoader, CachingProvider provider, Properties properties) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Classloader cannot be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Invalid CacheManager URI " + uri);
        }
        this.uri = uri;
        this.provider = provider;
        this.properties = properties;
        ConfigurationBuilderHolder cbh = this.getConfigurationBuilderHolder(classLoader);
        GlobalConfigurationBuilder globalBuilder = cbh.getGlobalConfigurationBuilder();
        String cacheManagerName = "uri=" + uri + "/classloader=" + classLoader.toString() + "/provider=" + provider.toString();
        globalBuilder.classLoader(classLoader).globalJmxStatistics().cacheManagerName(cacheManagerName);
        this.cm = new DefaultCacheManager(cbh, true);
        this.registerPredefinedCaches();
        this.isClosed = false;
        this.managedCacheManager = false;
    }

    public JCacheManager(URI uri, EmbeddedCacheManager cacheManager, CachingProvider provider) {
        this.uri = uri;
        this.provider = provider;
        this.cm = cacheManager;
        this.managedCacheManager = true;
        this.properties = null;
        this.registerPredefinedCaches();
    }

    private void registerPredefinedCaches() {
        Set cacheNames = this.cm.getCacheNames();
        for (String cacheName : cacheNames) {
            this.caches.put(cacheName, new JCache(this.cm.getCache(cacheName).getAdvancedCache(), this, ConfigurationAdapter.create()));
        }
    }

    private ConfigurationBuilderHolder getConfigurationBuilderHolder(ClassLoader classLoader) {
        try {
            FileLookup fileLookup = new FileLookup();
            InputStream configurationStream = this.uri.isAbsolute() ? fileLookup.lookupFileStrict(this.uri, classLoader) : fileLookup.lookupFileStrict(this.uri.toString(), classLoader);
            return new ParserRegistry(classLoader).parse(configurationStream);
        }
        catch (FileNotFoundException e) {
            return new ConfigurationBuilderHolder(classLoader);
        }
    }

    public CachingProvider getCachingProvider() {
        return this.provider;
    }

    public URI getURI() {
        return this.uri;
    }

    public Properties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) {
        this.checkNotClosed().checkNull(cacheName, "cacheName").checkNull(configuration, "configuration");
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            AdvancedCache ispnCache;
            ConfigurationAdapter adapter;
            JCache<Object, Object> cache = this.caches.get(cacheName);
            if (cache == null) {
                adapter = ConfigurationAdapter.create(configuration);
                this.cm.defineConfiguration(cacheName, adapter.build());
                ispnCache = this.cm.getCache(cacheName).getAdvancedCache();
                if (!ispnCache.getStatus().allowInvocations()) {
                    ispnCache.start();
                }
            } else {
                throw log.cacheAlreadyRegistered(cacheName, cache.getConfiguration(Configuration.class), configuration);
            }
            cache = new JCache(ispnCache, this, adapter);
            this.caches.put(cache.getName(), cache);
            return this.unchecked(cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.checkNotClosed().checkNull(keyType, "keyType").checkNull(valueType, "valueType");
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            Cache<K, V> cache = this.unchecked((Cache)this.caches.get(cacheName));
            if (cache != null) {
                Configuration configuration = cache.getConfiguration(Configuration.class);
                Class cfgKeyType = configuration.getKeyType();
                if (this.verifyType(keyType, cfgKeyType)) {
                    Class cfgValueType = configuration.getValueType();
                    if (this.verifyType(valueType, cfgValueType)) {
                        return cache;
                    }
                    throw log.incompatibleType(valueType, cfgValueType);
                }
                throw log.incompatibleType(keyType, cfgKeyType);
            }
            return null;
        }
    }

    private <K> boolean verifyType(Class<K> type, Class<?> cfgType) {
        return cfgType != null && cfgType.equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getOrCreateCache(String cacheName, AdvancedCache<K, V> ispnCache) {
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            JCache<Object, Object> cache = this.caches.get(cacheName);
            if (cache == null) {
                cache = new JCache<K, V>(ispnCache, this, ConfigurationAdapter.create());
                this.caches.put(cacheName, cache);
            }
            return this.unchecked(cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.checkNotClosed();
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            Cache<K, V> cache = this.unchecked((Cache)this.caches.get(cacheName));
            if (cache != null) {
                Configuration configuration = cache.getConfiguration(Configuration.class);
                Class keyType = configuration.getKeyType();
                Class valueType = configuration.getValueType();
                if (Object.class.equals((Object)keyType) && Object.class.equals((Object)valueType)) {
                    return cache;
                }
                throw log.unsafeTypedCacheRequest(cacheName, keyType, valueType);
            }
            return null;
        }
    }

    public Iterable<String> getCacheNames() {
        return this.isClosed ? InfinispanCollections.emptyList() : this.cm.getCacheNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyCache(String cacheName) {
        JCache<?, ?> destroyedCache;
        this.checkNotClosed().checkNull(cacheName, "cacheName");
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            destroyedCache = this.caches.remove(cacheName);
        }
        this.cm.removeCache(cacheName);
        this.unregisterCacheMBeans(destroyedCache);
    }

    private void unregisterCacheMBeans(JCache<?, ?> cache) {
        if (cache != null) {
            RIMBeanServerRegistrationUtility.unregisterCacheObject(cache, RIMBeanServerRegistrationUtility.ObjectNameType.STATISTICS);
            RIMBeanServerRegistrationUtility.unregisterCacheObject(cache, RIMBeanServerRegistrationUtility.ObjectNameType.CONFIGURATION);
        }
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.checkNotClosed();
        this.caches.get(cacheName).setManagementEnabled(enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkNotClosed();
        this.caches.get(cacheName).setStatisticsEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.isClosed()) {
            ArrayList cacheList;
            HashMap<String, JCache<?, ?>> hashMap = this.caches;
            synchronized (hashMap) {
                cacheList = new ArrayList(this.caches.values());
                this.caches.clear();
            }
            for (JCache<?, ?> cache : cacheList) {
                try {
                    cache.close();
                    this.unregisterCacheMBeans(cache);
                }
                catch (Exception e) {}
            }
            this.cm.stop();
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.cm.getStatus().isTerminated() || this.isClosed;
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrap((Object)this, clazz);
    }

    public ClassLoader getClassLoader() {
        return this.cm.getCacheManagerConfiguration().classLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.managedCacheManager && !this.isClosed) {
                Log.LeakDescription t = log.cacheManagerNotClosed();
                t.setStackTrace(this.allocationStackTrace);
                log.leakedCacheManager(t);
                this.cm.stop();
            }
        }
        finally {
            super.finalize();
        }
    }

    private JCacheManager checkNotClosed() {
        if (this.isClosed()) {
            throw log.cacheManagerClosed(this.cm.getStatus());
        }
        return this;
    }

    private JCacheManager checkNull(Object obj, String name) {
        if (obj == null) {
            throw log.parameterMustNotBeNull(name);
        }
        return this;
    }

    private <K, V> Cache<K, V> unchecked(Cache<?, ?> cache) {
        return cache;
    }
}

