/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.integration.CompletionListener;
import javax.cache.integration.CompletionListenerFuture;
import org.infinispan.Cache;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jcache.embedded.JCacheManager;
import org.infinispan.jcache.util.InMemoryJCacheLoader;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jcache.JCacheLoaderTest")
public class JCacheLoaderTest {
    public void testLoadAllWithJCacheLoader(Method m) {
        final String cacheName = m.getName();
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((boolean)false)){

            public void call() {
                JCacheManager jCacheManager = JCacheLoaderTest.createJCacheManager(this.cm, (Object)this);
                InMemoryJCacheLoader cacheLoader = new InMemoryJCacheLoader();
                cacheLoader.store((Object)1, (Object)"v1").store((Object)2, (Object)"v2");
                MutableConfiguration cfg = new MutableConfiguration();
                cfg.setCacheLoaderFactory((Factory)new FactoryBuilder.SingletonFactory((Object)cacheLoader));
                javax.cache.Cache cache = jCacheManager.createCache(cacheName, (Configuration)cfg);
                AssertJUnit.assertEquals((long)0L, (long)cacheLoader.getLoadCount());
                CompletionListenerFuture future = new CompletionListenerFuture();
                cache.loadAll(CollectionFactory.makeSet((Object[])new Integer[]{1, 2}), true, (CompletionListener)future);
                JCacheLoaderTest.this.futureGet(future);
                AssertJUnit.assertEquals((long)2L, (long)cacheLoader.getLoadCount());
            }
        });
    }

    public void testLoadAllWithInfinispanCacheLoader() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((boolean)false)){

            public void call() {
                ConfigurationBuilder builder = new ConfigurationBuilder();
                ((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(((Object)((Object)this)).getClass().getName());
                this.cm.defineConfiguration("dummyStore", builder.build());
                JCacheManager jCacheManager = JCacheLoaderTest.createJCacheManager(this.cm, (Object)this);
                javax.cache.Cache cache = jCacheManager.getCache("dummyStore");
                int numEntries = JCacheLoaderTest.loadInitialData(this.cm);
                DummyInMemoryStore dummyStore = (DummyInMemoryStore)TestingUtil.getFirstWriter((Cache)this.cm.getCache("dummyStore"));
                CompletionListenerFuture future = new CompletionListenerFuture();
                Set<Integer> keys = Collections.singleton(1);
                cache.loadAll(keys, false, (CompletionListener)future);
                JCacheLoaderTest.this.futureGet(future);
                AssertJUnit.assertTrue((boolean)future.isDone());
                AssertJUnit.assertEquals((int)numEntries, (int)((Integer)dummyStore.stats().get("load")));
                AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)1)));
                future = new CompletionListenerFuture();
                cache.loadAll(keys, true, (CompletionListener)future);
                JCacheLoaderTest.this.futureGet(future);
                AssertJUnit.assertTrue((boolean)future.isDone());
                AssertJUnit.assertEquals((int)(numEntries * 2), (int)((Integer)dummyStore.stats().get("load")));
            }
        });
    }

    private Void futureGet(CompletionListenerFuture future) {
        try {
            return future.get();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    private static int loadInitialData(EmbeddedCacheManager cm) {
        TestingUtil.writeToAllStores((Object)1, (Object)"v1", (Cache)cm.getCache("dummyStore"));
        return 1;
    }

    private static JCacheManager createJCacheManager(EmbeddedCacheManager cm, Object creator) {
        return new JCacheManager(URI.create(creator.getClass().getName()), cm, null);
    }
}

