/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.lang.reflect.Method;
import java.net.URI;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jcache.AbstractTwoCachesAnnotationsTest;
import org.infinispan.jcache.CacheProducer;
import org.infinispan.jcache.JCacheAnnotatedClass;
import org.infinispan.jcache.annotation.InjectedCachePutInterceptor;
import org.infinispan.jcache.embedded.JCache;
import org.infinispan.jcache.embedded.JCacheManager;
import org.infinispan.jcache.util.JCacheTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(testName="org.infinispan.jcache.JCacheTwoCachesAnnotationsTest", groups={"functional"})
public class JCacheTwoCachesAnnotationsTest
extends AbstractTwoCachesAnnotationsTest {
    private EmbeddedCacheManager cacheManager1;
    private EmbeddedCacheManager cacheManager2;
    @Inject
    private JCacheAnnotatedClass jCacheAnnotatedClass;

    @Deployment
    public static JavaArchive createDeployment() {
        return (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addPackage(JCacheAnnotatedClass.class.getPackage())).addPackage(JCache.class.getPackage())).addPackage(InjectedCachePutInterceptor.class.getPackage())).addPackage(CacheProducer.class.getPackage())).addPackage(JCacheTestingUtil.class.getPackage())).addAsResource(JCacheTwoCachesAnnotationsTest.class.getResource("/beans.xml"), "beans.xml");
    }

    public JCacheAnnotatedClass getJCacheAnnotatedClass() {
        return this.jCacheAnnotatedClass;
    }

    public javax.cache.Cache getCache1(Method m) {
        JCacheManager jCacheManager = new JCacheManager(URI.create(m.getName()), this.cacheManager1, null);
        return jCacheManager.getCache("annotation");
    }

    public javax.cache.Cache getCache2(Method m) {
        JCacheManager jCacheManager = new JCacheManager(URI.create(m.getName()), this.cacheManager2, null);
        return jCacheManager.getCache("annotation");
    }

    @BeforeTest
    public void initCacheManagers() {
        this.cacheManager1 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC));
        this.cacheManager1.defineConfiguration("annotation", AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC).build());
        this.cacheManager2 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC));
        this.cacheManager2.defineConfiguration("annotation", AbstractCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC).build());
        TestingUtil.blockUntilViewsReceived((long)30000L, (Cache[])new Cache[]{this.cacheManager1.getCache("annotation"), this.cacheManager2.getCache("annotation")});
    }

    @AfterMethod
    public void cleanCaches() {
        TestingUtil.clearContent((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager1, this.cacheManager2});
    }

    @AfterTest
    public void killCacheManagers() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager1, this.cacheManager2});
    }
}

