/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.net.URI;
import javax.cache.configuration.MutableConfiguration;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jcache.embedded.JCacheManager;
import org.infinispan.jcache.util.JCacheTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="jcache.JCacheConfigurationTest")
public class JCacheConfigurationTest
extends AbstractInfinispanTest {
    public void testNamedCacheConfiguration() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((boolean)false)){

            public void call() {
                this.cm.defineConfiguration("oneCache", new ConfigurationBuilder().build());
                JCacheManager jCacheManager = new JCacheManager(URI.create("oneCacheManager"), this.cm, null);
                AssertJUnit.assertTrue((null != jCacheManager.getCache("oneCache") ? 1 : 0) != 0);
            }
        });
    }

    public void testJCacheManagerWherePathContainsFileSchemaAndAbsolutePath() throws Exception {
        URI uri = JCacheConfigurationTest.class.getClassLoader().getResource("infinispan_uri.xml").toURI();
        JCacheTestingUtil.withCachingProvider(provider -> {
            JCacheManager jCacheManager = new JCacheManager(uri, provider.getClass().getClassLoader(), provider, null);
            AssertJUnit.assertTrue((null != jCacheManager.getCache("foo") ? 1 : 0) != 0);
        });
    }

    public void testJCacheManagerWherePathContainsJarFileSchema() throws Exception {
        URI uri = JCacheConfigurationTest.class.getClassLoader().getResource("infinispan_uri.xml").toURI();
        URI uriWithJarFileSchema = URI.create(uri.toString().replace("file", "jar:file"));
        JCacheTestingUtil.withCachingProvider(provider -> {
            JCacheManager jCacheManager = new JCacheManager(uriWithJarFileSchema, provider.getClass().getClassLoader(), provider, null);
            AssertJUnit.assertTrue((null != jCacheManager.getCache("foo") ? 1 : 0) != 0);
        });
    }

    public void testJCacheManagerWithWildcardCacheConfigurations() throws Exception {
        URI uri = JCacheConfigurationTest.class.getClassLoader().getResource("infinispan_uri.xml").toURI();
        JCacheTestingUtil.withCachingProvider(provider -> {
            JCacheManager jCacheManager = new JCacheManager(uri, provider.getClass().getClassLoader(), provider, null);
            javax.cache.Cache wildcache1 = jCacheManager.createCache("wildcache1", (javax.cache.configuration.Configuration)new MutableConfiguration());
            Cache unwrap = (Cache)wildcache1.unwrap(Cache.class);
            Configuration configuration = unwrap.getCacheConfiguration();
            AssertJUnit.assertEquals((long)10500L, (long)configuration.expiration().wakeUpInterval());
            AssertJUnit.assertEquals((long)11L, (long)configuration.expiration().lifespan());
            AssertJUnit.assertEquals((long)11L, (long)configuration.expiration().maxIdle());
        });
    }
}

