/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr;

import java.util.Properties;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.settings.ConnectionSettings;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.connection.support.metadata.ConnectionTypeDescriptor;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;

public class ConnectionHelper {
    private final Log log = LogFactory.getLog(ConnectionHelper.class);
    private EmsConnection connection;
    private int consecutiveConnectionErrors;

    public EmsConnection getEmsConnection(Configuration config) {
        EmsConnection emsConnection = null;
        try {
            emsConnection = this.loadConnection(config);
        }
        catch (Exception e) {
            this.log.error((Object)"Component attempting to access a connection that could not be loaded");
        }
        return emsConnection;
    }

    private synchronized EmsConnection loadConnection(Configuration pluginConfig) throws Exception {
        if (this.connection == null) {
            try {
                ConnectionSettings connectionSettings = new ConnectionSettings();
                String connectionTypeDescriptorClass = pluginConfig.getSimple("type").getStringValue();
                PropertySimple serverUrl = pluginConfig.getSimple("connectorAddress");
                connectionSettings.initializeConnectionType((ConnectionTypeDescriptor)Util.getInstance((String)connectionTypeDescriptorClass));
                if (null != serverUrl) {
                    connectionSettings.setServerUrl(serverUrl.getStringValue());
                }
                if (connectionSettings.getAdvancedProperties() == null) {
                    connectionSettings.setAdvancedProperties(new Properties());
                }
                ConnectionFactory connectionFactory = new ConnectionFactory();
                ConnectionProvider connectionProvider = connectionFactory.getConnectionProvider(connectionSettings);
                this.connection = connectionProvider.connect();
                this.connection.loadSynchronous(false);
                this.consecutiveConnectionErrors = 0;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Successfully made connection to the remote server instance");
                }
            }
            catch (Exception e) {
                if (this.connection != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Connection created but an exception was thrown. Closing the connection.", (Throwable)e);
                    }
                    this.connection.close();
                    this.connection = null;
                }
                if (this.consecutiveConnectionErrors % 10 == 0) {
                    this.log.warn((Object)("Could not establish connection to the Infinispan instance [" + (this.consecutiveConnectionErrors + 1) + "] times."), (Throwable)e);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Could not connect to the Infinispan instance for resource ", (Throwable)e);
                }
                ++this.consecutiveConnectionErrors;
                throw e;
            }
        }
        return this.connection;
    }

    public synchronized void closeConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception e) {
                this.log.error((Object)("Error closing Infinispan EMS connection: " + e));
            }
            this.connection = null;
        }
    }
}

