/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.jopr.CacheManagerComponent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheDiscovery
implements ResourceDiscoveryComponent<CacheManagerComponent> {
    private static final Log log = LogFactory.getLog(CacheDiscovery.class);
    static final String CACHE_QUERY = "*:cache-name=%name%,jmx-resource=Cache";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<CacheManagerComponent> discoveryContext) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Discover resources with context: " + discoveryContext));
        }
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        EmsConnection conn = ((CacheManagerComponent)discoveryContext.getParentResourceComponent()).getConnection();
        if (trace) {
            log.trace((Object)("Connection to ems server stablished: " + conn));
        }
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(CACHE_QUERY);
        List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
        if (trace) {
            log.trace((Object)("Querying [" + queryUtility.getTranslatedQuery() + "] returned beans: " + beans));
        }
        for (EmsBean bean : beans) {
            String name = bean.getAttribute("CacheName").getValue().toString();
            if (trace) {
                log.trace((Object)"Resource name is {0}", new Object[]{name});
            }
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), bean.getBeanName().getCanonicalName(), name, null, "One cache within Infinispan", discoveryContext.getDefaultPluginConfiguration(), null);
            discoveredResources.add(detail);
            log.info((Object)("Discovered new ...  " + bean.getBeanName().getCanonicalName()));
        }
        return discoveredResources;
    }
}

