/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.jopr.CacheManagerComponent;
import org.infinispan.jopr.ConnectionHelper;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheManagerDiscovery
implements ResourceDiscoveryComponent<CacheManagerComponent> {
    private static final Log log = LogFactory.getLog(CacheManagerDiscovery.class);
    public static String REMOTE = "service:jmx:rmi://127.0.0.1/jndi/rmi://127.0.0.1:6996/jmxrmi";
    private static final String MANAGER_OBJECT = "*:cache-name=[global],jmx-resource=CacheManager";
    private static final String CONNECTOR = "org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor";
    private static final String OBJECT_NAME_KEY = "objectName";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<CacheManagerComponent> ctx) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Discover resources with context: {0}", new Object[]{ctx});
        }
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        DiscoveredResourceDetails resource = null;
        List manualCfgs = ctx.getPluginConfigurations();
        if (!manualCfgs.isEmpty()) {
            Configuration cfg = (Configuration)ctx.getPluginConfigurations().get(0);
            String objectName = cfg.getSimple(OBJECT_NAME_KEY).getStringValue();
            String connectorAddress = cfg.getSimple("connectorAddress").getStringValue();
            resource = this.createDiscoveredResource(ctx, objectName, connectorAddress);
            if (trace) {
                log.trace((Object)"Manually discovered resource is {0}", new Object[]{resource});
            }
        } else {
            resource = this.createDiscoveredResource(ctx, MANAGER_OBJECT, REMOTE);
            if (trace) {
                log.trace((Object)"Automatically discovered resource is {0}", new Object[]{resource});
            }
            discoveredResources.add(resource);
        }
        discoveredResources.add(resource);
        return discoveredResources;
    }

    private DiscoveredResourceDetails createDiscoveredResource(ResourceDiscoveryContext ctx, String objectName, String connectorAddress) {
        ConnectionHelper helper;
        EmsConnection conn;
        boolean trace = log.isTraceEnabled();
        Configuration c = new Configuration();
        c.put((Property)new PropertySimple(OBJECT_NAME_KEY, (Object)objectName));
        c.put((Property)new PropertySimple("connectorAddress", (Object)connectorAddress));
        c.put((Property)new PropertySimple("type", (Object)CONNECTOR));
        if (trace) {
            log.trace((Object)"Configuration is {0}", new Object[]{c.toString(true)});
        }
        if ((conn = (helper = new ConnectionHelper()).getEmsConnection(c)) != null) {
            if (trace) {
                log.trace((Object)"Connection to ems server stablished: {0}", new Object[]{conn});
            }
            ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(objectName);
            List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
            if (trace) {
                log.trace((Object)"Querying [{0}] returned beans: {1}", new Object[]{queryUtility.getTranslatedQuery(), beans});
            }
            EmsBean bean = (EmsBean)beans.get(0);
            String managerName = bean.getBeanName().getCanonicalName();
            String resourceName = bean.getAttribute("Name").getValue().toString();
            String version = bean.getAttribute("Version").getValue().toString();
            if (trace) {
                log.trace((Object)"Add resource with version '{1}' and type {2}", new Object[]{version, ctx.getResourceType()});
            }
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(ctx.getResourceType(), resourceName, resourceName, version, "A cache manager within Infinispan", c, null);
            log.info((Object)"Discovered Infinispan instance with key {0} and name {1}", new Object[]{resourceName, managerName});
            return detail;
        }
        log.debug((Object)"Unable to establish connection");
        return null;
    }
}

