/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucenedemo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucenedemo.DirectoryFactory;
import org.infinispan.remoting.transport.Address;

public class DemoActions {
    private static final String MAIN_FIELD = "myField";
    private static final Analyzer analyzer = new StandardAnalyzer();
    private InfinispanDirectory index = DirectoryFactory.getIndex("index");

    public List<String> listStoredValuesMatchingQuery(Query query) throws IOException {
        IndexSearcher searcher = new IndexSearcher((Directory)this.index);
        TopDocs topDocs = searcher.search(query, null, 100);
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        ArrayList<String> list = new ArrayList<String>();
        for (ScoreDoc sd : scoreDocs) {
            Document doc = searcher.doc(sd.doc);
            list.add(doc.get(MAIN_FIELD));
        }
        return list;
    }

    public List<String> listAllDocuments() throws IOException {
        MatchAllDocsQuery q = new MatchAllDocsQuery();
        return this.listStoredValuesMatchingQuery((Query)q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewDocument(String line) throws IOException {
        IndexWriter iw = new IndexWriter((Directory)this.index, analyzer, IndexWriter.MaxFieldLength.UNLIMITED);
        try {
            Document doc = new Document();
            Field field = new Field(MAIN_FIELD, line, Field.Store.YES, Field.Index.ANALYZED);
            doc.add((Fieldable)field);
            iw.addDocument(doc);
            iw.commit();
        }
        finally {
            iw.close();
        }
    }

    public Query parseQuery(String queryLine) throws ParseException {
        QueryParser parser = new QueryParser(MAIN_FIELD, analyzer);
        Query query = parser.parse(queryLine);
        return query;
    }

    public List<Address> listAllMembers() {
        return this.index.getCache().getCacheManager().getMembers();
    }
}

