/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucenedemo;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.manager.CacheManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;

public class DirectoryFactory {
    public static final String CACHE_NAME_FOR_INDEXES = "LuceneIndex";
    private static CacheManager manager = null;
    private static final Map<String, InfinispanDirectory> directories = new HashMap<String, InfinispanDirectory>();

    private static Cache<CacheKey, Object> buildCacheForIndexes() {
        return DirectoryFactory.getCacheManager().getCache(CACHE_NAME_FOR_INDEXES);
    }

    public static synchronized CacheManager getCacheManager() {
        if (manager != null) {
            return manager;
        }
        GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
        gc.setClusterName("infinispan-lucene-demo-cluster");
        gc.setTransportClass(JGroupsTransport.class.getName());
        Properties p = new Properties();
        p.setProperty("configurationFile", "jgroups-configuration.xml");
        gc.setTransportProperties(p);
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.DIST_SYNC);
        config.setSyncCommitPhase(true);
        config.setSyncRollbackPhase(true);
        config.setTransactionManagerLookupClass(JBossStandaloneJTAManagerLookup.class.getName());
        config.setNumOwners(2);
        config.setL1CacheEnabled(true);
        config.setInvocationBatchingEnabled(true);
        config.setL1Lifespan(6000000L);
        manager = new DefaultCacheManager(gc, config, false);
        return manager;
    }

    public static synchronized InfinispanDirectory getIndex(String indexName) {
        InfinispanDirectory dir = directories.get(indexName);
        if (dir == null) {
            dir = new InfinispanDirectory(DirectoryFactory.buildCacheForIndexes(), indexName);
            directories.put(indexName, dir);
        }
        return dir;
    }
}

