/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucenedemo;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucenedemo.DemoActions;
import org.infinispan.lucenedemo.DirectoryFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class CacheConfigurationTest {
    private InfinispanDirectory cacheForIndex1;
    private InfinispanDirectory cacheForIndex2;
    private InfinispanDirectory cacheForIndex3;

    @BeforeClass
    public void init() {
        this.cacheForIndex1 = DirectoryFactory.getIndex((String)"firstIndex");
        this.cacheForIndex2 = DirectoryFactory.getIndex((String)"firstIndex");
        this.cacheForIndex3 = DirectoryFactory.getIndex((String)"secondIndex");
    }

    @AfterClass
    public void cleanup() {
        DirectoryFactory.close();
    }

    @Test
    public void testCorrectCacheInstances() {
        assert (this.cacheForIndex1 != null);
        assert (this.cacheForIndex1 == this.cacheForIndex2);
        assert (this.cacheForIndex1 != this.cacheForIndex3);
    }

    @Test
    public void inserting() throws IOException, ParseException {
        DemoActions node1 = new DemoActions(this.cacheForIndex1);
        DemoActions node2 = new DemoActions(this.cacheForIndex2);
        node1.addNewDocument("hello?");
        assert (node1.listAllDocuments().size() == 1);
        node1.addNewDocument("anybody there?");
        assert (node2.listAllDocuments().size() == 2);
        Query query = node1.parseQuery("hello world");
        List valuesMatchingQuery = node2.listStoredValuesMatchingQuery(query);
        assert (valuesMatchingQuery.size() == 1);
        assert (((String)valuesMatchingQuery.get(0)).equals("hello?"));
    }
}

