/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucenedemo;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.lucene.InfinispanDirectory;
import org.infinispan.lucenedemo.DemoActions;
import org.infinispan.manager.DefaultCacheManager;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucenedemo.CacheConfigurationTest")
public class CacheConfigurationTest {
    private DefaultCacheManager cacheManager1;
    private DefaultCacheManager cacheManager2;
    private InfinispanDirectory directoryNodeOne;
    private InfinispanDirectory directoryNodeTwo;
    private Cache cache1;
    private Cache cache2;

    @BeforeTest
    public void init() throws IOException {
        this.cacheManager1 = new DefaultCacheManager("config-samples/lucene-demo-cache-config.xml");
        this.cacheManager1.start();
        this.cache1 = this.cacheManager1.getCache();
        this.cache1.clear();
        this.directoryNodeOne = new InfinispanDirectory(this.cache1);
        this.cacheManager2 = new DefaultCacheManager("config-samples/lucene-demo-cache-config.xml");
        this.cacheManager2.start();
        this.cache2 = this.cacheManager2.getCache();
        this.cache2.clear();
        this.directoryNodeTwo = new InfinispanDirectory(this.cache2);
    }

    @AfterTest
    public void cleanup() {
        this.directoryNodeOne.close();
        this.directoryNodeTwo.close();
        this.cacheManager1.stop();
        this.cacheManager2.stop();
    }

    @Test
    public void inserting() throws IOException, ParseException {
        DemoActions node1 = new DemoActions(this.directoryNodeOne, this.cache1);
        DemoActions node2 = new DemoActions(this.directoryNodeTwo, this.cache2);
        node1.addNewDocument("hello?");
        assert (node1.listAllDocuments().size() == 1);
        node1.addNewDocument("anybody there?");
        assert (node2.listAllDocuments().size() == 2);
        Query query = node1.parseQuery("hello world");
        List valuesMatchingQuery = node2.listStoredValuesMatchingQuery(query);
        assert (valuesMatchingQuery.size() == 1);
        assert (((String)valuesMatchingQuery.get(0)).equals("hello?"));
    }
}

