/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucenedemo;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucenedemo.DemoActions;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucenedemo.CacheConfigurationTest")
public class CacheConfigurationTest {
    private EmbeddedCacheManager cacheManager1;
    private EmbeddedCacheManager cacheManager2;
    private Directory directoryNodeOne;
    private Directory directoryNodeTwo;
    private Cache cache1;
    private Cache cache2;

    @BeforeTest
    public void init() throws IOException {
        this.cacheManager1 = TestCacheManagerFactory.fromXml((String)"config-samples/lucene-demo-cache-config.xml");
        this.cacheManager1.start();
        this.cache1 = this.cacheManager1.getCache();
        this.cache1.clear();
        this.directoryNodeOne = DirectoryBuilder.newDirectoryInstance((Cache)this.cache1, (Cache)this.cache1, (Cache)this.cache1, (String)"index-name").create();
        this.cacheManager2 = TestCacheManagerFactory.fromXml((String)"config-samples/lucene-demo-cache-config.xml");
        this.cacheManager2.start();
        this.cache2 = this.cacheManager2.getCache();
        this.cache2.clear();
        this.directoryNodeTwo = DirectoryBuilder.newDirectoryInstance((Cache)this.cache2, (Cache)this.cache2, (Cache)this.cache2, (String)"index-name").create();
    }

    @AfterTest
    public void cleanup() throws IOException {
        this.directoryNodeOne.close();
        this.directoryNodeTwo.close();
        this.cacheManager1.stop();
        this.cacheManager2.stop();
    }

    @Test
    public void inserting() throws IOException, ParseException {
        DemoActions node1 = new DemoActions(this.directoryNodeOne, this.cache1);
        DemoActions node2 = new DemoActions(this.directoryNodeTwo, this.cache2);
        node1.addNewDocument("hello?");
        assert (node1.listAllDocuments().size() == 1);
        node1.addNewDocument("anybody there?");
        assert (node2.listAllDocuments().size() == 2);
        Query query = node1.parseQuery("hello world");
        List valuesMatchingQuery = node2.listStoredValuesMatchingQuery(query);
        assert (valuesMatchingQuery.size() == 1);
        assert (((String)valuesMatchingQuery.get(0)).equals("hello?"));
    }
}

