/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucenedemo;

import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucenedemo.DemoActions;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.remoting.transport.Address;

public class DemoDriver
implements Runnable {
    private final DemoActions actions;

    public DemoDriver(Directory infinispanDirectory, Cache<?, ?> cache) {
        this.actions = new DemoActions(infinispanDirectory, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        DefaultCacheManager cacheManager = new DefaultCacheManager("config-samples/lucene-demo-cache-config.xml");
        cacheManager.start();
        try {
            Cache cache = cacheManager.getCache();
            Directory directory = DirectoryBuilder.newDirectoryInstance((Cache)cache, (Cache)cache, (Cache)cache, (String)"index-name").create();
            DemoDriver driver = new DemoDriver(directory, cache);
            driver.run();
        }
        finally {
            cacheManager.stop();
        }
    }

    private void doQuery(Scanner scanner) {
        scanner.nextLine();
        Query query = null;
        while (query == null) {
            System.out.println("Enter a query:");
            String queryLine = scanner.nextLine();
            try {
                query = this.actions.parseQuery(queryLine);
            }
            catch (ParseException e) {
                System.out.println("Wrong syntax in query: " + e.getMessage());
                System.out.println("type it again: ");
            }
        }
        List<String> listMatches = this.actions.listStoredValuesMatchingQuery(query);
        this.printResult(listMatches);
    }

    private void insertNewText(Scanner scanner) throws IOException {
        System.out.println("Enter string as new document:");
        scanner.nextLine();
        String line = scanner.nextLine();
        this.actions.addNewDocument(line);
    }

    private void listAllDocuments() {
        List<String> listMatches = this.actions.listAllDocuments();
        this.printResult(listMatches);
    }

    private void listMembers() {
        List<Address> members = this.actions.listAllMembers();
        System.out.println("\tmembers:\t" + members);
    }

    private void showOptions() {
        System.out.println("Options:\n\t[1] List cluster members\n\t[2] List all documents in index\n\t[3] insert new text\n\t[4] enter a query\n\t[5] quit");
    }

    private void printResult(List<String> storedValues) {
        System.out.println("Matching documents:\n");
        if (storedValues.isEmpty()) {
            System.out.println("\tNo documents found.");
        } else {
            int i = 0;
            for (String value : storedValues) {
                System.out.println(++i + "\t\"" + value + "\"");
            }
        }
    }

    @Override
    public void run() {
        Scanner scanner = new Scanner(System.in);
        while (true) {
            this.showOptions();
            boolean warned = false;
            while (!scanner.hasNextInt()) {
                if (!warned) {
                    System.out.println("Invalid option, try again:");
                    warned = true;
                }
                scanner.nextLine();
            }
            int result = scanner.nextInt();
            try {
                switch (result) {
                    case 1: {
                        this.listMembers();
                        break;
                    }
                    case 2: {
                        this.listAllDocuments();
                        break;
                    }
                    case 3: {
                        this.insertNewText(scanner);
                        break;
                    }
                    case 4: {
                        this.doQuery(scanner);
                        break;
                    }
                    case 5: {
                        System.out.println("Quit.");
                        return;
                    }
                    default: {
                        System.out.println("Invalid option.");
                    }
                }
                System.out.println("");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

