/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucenedemo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;

public class DemoActions {
    private static final String MAIN_FIELD = "myField";
    private static final Version luceneVersion = Version.LATEST;
    private static final Analyzer analyzer = new StandardAnalyzer();
    private final Directory index;
    private final Cache<?, ?> cache;

    public DemoActions(Directory index, Cache<?, ?> cache) {
        this.index = index;
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listStoredValuesMatchingQuery(Query query) {
        ArrayList<String> arrayList;
        DirectoryReader reader = DirectoryReader.open((Directory)this.index);
        try {
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            TopDocs topDocs = searcher.search(query, null, 100);
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            ArrayList<String> list = new ArrayList<String>();
            for (ScoreDoc sd : scoreDocs) {
                Document doc = searcher.doc(sd.doc);
                list.add(doc.get(MAIN_FIELD));
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }

    public List<String> listAllDocuments() {
        MatchAllDocsQuery q = new MatchAllDocsQuery();
        return this.listStoredValuesMatchingQuery((Query)q);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewDocument(String line) throws IOException {
        IndexWriterConfig config = this.makeIndexWriterConfig();
        try (IndexWriter iw = new IndexWriter(this.index, config);){
            Document doc = new Document();
            TextField field = new TextField(MAIN_FIELD, line, Field.Store.YES);
            doc.add((IndexableField)field);
            iw.addDocument((Iterable)doc);
            iw.commit();
        }
    }

    private IndexWriterConfig makeIndexWriterConfig() {
        return new IndexWriterConfig(analyzer);
    }

    public Query parseQuery(String queryLine) throws ParseException {
        QueryParser parser = new QueryParser(MAIN_FIELD, analyzer);
        return parser.parse(queryLine);
    }

    public List<Address> listAllMembers() {
        EmbeddedCacheManager cacheManager = this.cache.getCacheManager();
        return cacheManager.getMembers();
    }
}

