/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DynamicBufferSizeTest")
public class DynamicBufferSizeTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration((boolean)true);
        builder.clustering().cacheMode(CacheMode.LOCAL).invocationBatching().enable();
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
    }

    @Test
    public void roundingTest() {
        FileMetadata m = new FileMetadata(10);
        AssertJUnit.assertEquals((int)0, (int)m.getNumberOfChunks());
        m.setSize(10L);
        AssertJUnit.assertEquals((int)1, (int)m.getNumberOfChunks());
        m.setSize(11L);
        AssertJUnit.assertEquals((int)2, (int)m.getNumberOfChunks());
        m = new FileMetadata(11);
        m.setSize(11L);
        AssertJUnit.assertEquals((int)1, (int)m.getNumberOfChunks());
        m.setSize(22L);
        AssertJUnit.assertEquals((int)2, (int)m.getNumberOfChunks());
        m.setSize(31L);
        m = new FileMetadata(10);
        m.setSize(31L);
        AssertJUnit.assertEquals((int)4, (int)m.getNumberOfChunks());
    }

    @Test
    public void testReadingFromDifferentlySizedBuffers() throws IOException {
        this.cache = this.cacheManager.getCache();
        Directory dirA = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)"indexName").chunkSize(7).create();
        CacheTestSupport.writeTextToIndex(dirA, 0, "hi from node A");
        Directory dirB = DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)"indexName").chunkSize(8).create();
        CacheTestSupport.assertTextIsFoundInIds(dirB, "hi", 0);
        CacheTestSupport.writeTextToIndex(dirB, 1, "index B is sharing the same index but using a differently sized chunk size");
        CacheTestSupport.assertTextIsFoundInIds(dirA, "size", 1);
    }

    @Test
    public void testFileMetaData() {
        FileMetadata data1 = new FileMetadata(1024);
        FileMetadata data2 = new FileMetadata(2048);
        FileMetadata data3 = new FileMetadata(1024);
        FileMetadata data4 = data1;
        assert (!data1.equals((Object)new FileCacheKey("testIndex", "testFile", -1)));
        AssertJUnit.assertNotNull((Object)data1);
        assert (data1.equals((Object)data4));
        assert (data1.equals((Object)data3));
        data3.setSize(2048L);
        assert (!data1.equals((Object)data3));
        assert (!data1.equals((Object)data2));
        AssertJUnit.assertEquals((String)("FileMetadata{size=" + data1.getSize() + '}'), (String)data1.toString());
    }
}

