package org.infinispan.lucene.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.configuration.cache.CacheMode;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import org.infinispan.persistence.spi.PersistenceException;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-02-26T16:11:45+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void errorSuspendingTransaction(final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorSuspendingTransaction$str());
    }
    private static final String errorSuspendingTransaction = "ISPN015001: Error in suspending transaction";
    protected String errorSuspendingTransaction$str() {
        return errorSuspendingTransaction;
    }
    @Override
    public final void unableToStartTransaction(final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToStartTransaction$str());
    }
    private static final String unableToStartTransaction = "ISPN015002: Unable to start transaction";
    protected String unableToStartTransaction$str() {
        return unableToStartTransaction;
    }
    @Override
    public final void unableToCommitTransaction(final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToCommitTransaction$str());
    }
    private static final String unableToCommitTransaction = "ISPN015003: Unable to commit work done";
    protected String unableToCommitTransaction$str() {
        return unableToCommitTransaction;
    }
    private static final String keyMappperUnexpectedStringFormat = "ISPN015004: Unexpected format of key in String form: '%s'";
    protected String keyMappperUnexpectedStringFormat$str() {
        return keyMappperUnexpectedStringFormat;
    }
    @Override
    public final IllegalArgumentException keyMappperUnexpectedStringFormat(final String key) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), keyMappperUnexpectedStringFormat$str(), key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cacheLoaderIgnoringKey(final Object key) {
        super.log.logf(FQCN, DEBUG, null, cacheLoaderIgnoringKey$str(), key);
    }
    private static final String cacheLoaderIgnoringKey = "ISPN015005: Lucene CacheLoader is ignoring key '%s'";
    protected String cacheLoaderIgnoringKey$str() {
        return cacheLoaderIgnoringKey;
    }
    private static final String rootDirectoryIsNotADirectory = "ISPN015006: The LuceneCacheLoader requires a directory; invalid path '%s'";
    protected String rootDirectoryIsNotADirectory$str() {
        return rootDirectoryIsNotADirectory;
    }
    @Override
    public final CacheException rootDirectoryIsNotADirectory(final String fileRoot) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), rootDirectoryIsNotADirectory$str(), fileRoot));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateDirectory = "ISPN015007: LuceneCacheLoader was unable to create the root directory at path '%s'";
    protected String unableToCreateDirectory$str() {
        return unableToCreateDirectory;
    }
    @Override
    public final CacheException unableToCreateDirectory(final String fileRoot) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToCreateDirectory$str(), fileRoot));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionInCacheLoader = "ISPN015008: IOException happened in the CacheLoader";
    protected String exceptionInCacheLoader$str() {
        return exceptionInCacheLoader;
    }
    @Override
    public final PersistenceException exceptionInCacheLoader(final Exception e) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), exceptionInCacheLoader$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorOnFSDirectoryClose(final IOException e) {
        super.log.logf(FQCN, WARN, e, errorOnFSDirectoryClose$str());
    }
    private static final String errorOnFSDirectoryClose = "ISPN015009: Unable to close FSDirectory";
    protected String errorOnFSDirectoryClose$str() {
        return errorOnFSDirectoryClose;
    }
    @Override
    public final void couldNotWalkDirectory(final String name, final PersistenceException e) {
        super.log.logf(FQCN, WARN, e, couldNotWalkDirectory$str(), name);
    }
    private static final String couldNotWalkDirectory = "ISPN015010: Error happened while looking for FSDirectories in '%s'";
    protected String couldNotWalkDirectory$str() {
        return couldNotWalkDirectory;
    }
    @Override
    public final void rescalingChunksize(final String fileName, final long fileLength, final int chunkSize) {
        super.log.logf(FQCN, WARN, null, rescalingChunksize$str(), fileName, fileLength, chunkSize);
    }
    private static final String rescalingChunksize = "ISPN015011: The configured autoChunkSize is too small for segment file %s as it is %d bytes; auto-scaling chunk size to %d";
    protected String rescalingChunksize$str() {
        return rescalingChunksize;
    }
    private static final String luceneStorageHavingLifespanSet = "ISPN015014: Lucene Directory for index '%s' can not use Cache '%s': maximum lifespan enabled on the Cache configuration!";
    protected String luceneStorageHavingLifespanSet$str() {
        return luceneStorageHavingLifespanSet;
    }
    @Override
    public final IllegalArgumentException luceneStorageHavingLifespanSet(final String indexName, final String cacheName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), luceneStorageHavingLifespanSet$str(), indexName, cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String luceneStorageHavingIdleTimeSet = "ISPN015015: Lucene Directory for index '%s' can not use Cache '%s': expiration idle time enabled on the Cache configuration!";
    protected String luceneStorageHavingIdleTimeSet$str() {
        return luceneStorageHavingIdleTimeSet;
    }
    @Override
    public final IllegalArgumentException luceneStorageHavingIdleTimeSet(final String indexName, final String cacheName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), luceneStorageHavingIdleTimeSet$str(), indexName, cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredParameterWasPassedNull = "ISPN015016: '%s' must not be null";
    protected String requiredParameterWasPassedNull$str() {
        return requiredParameterWasPassedNull;
    }
    @Override
    public final IllegalArgumentException requiredParameterWasPassedNull(final String objectname) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), requiredParameterWasPassedNull$str(), objectname));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String luceneStorageAsBinaryEnabled = "ISPN015017: Lucene Directory for index '%s' can not use Cache '%s': store as binary enabled on the Cache configuration!";
    protected String luceneStorageAsBinaryEnabled$str() {
        return luceneStorageAsBinaryEnabled;
    }
    @Override
    public final IllegalArgumentException luceneStorageAsBinaryEnabled(final String indexName, final String cacheName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), luceneStorageAsBinaryEnabled$str(), indexName, cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String evictionNotAllowedInMetadataCache = "ISPN015018: Lucene Directory for index '%s' can not use Metadata Cache '%s': eviction enabled on the Cache configuration!";
    protected String evictionNotAllowedInMetadataCache$str() {
        return evictionNotAllowedInMetadataCache;
    }
    @Override
    public final IllegalArgumentException evictionNotAllowedInMetadataCache(final String indexName, final String cacheName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), evictionNotAllowedInMetadataCache$str(), indexName, cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String preloadNeededIfPersistenceIsEnabledForMetadataCache = "ISPN015019: Lucene Directory for index '%s' can not use Metadata Cache '%s': persistence enabled without preload on the Cache configuration!";
    protected String preloadNeededIfPersistenceIsEnabledForMetadataCache$str() {
        return preloadNeededIfPersistenceIsEnabledForMetadataCache;
    }
    @Override
    public final IllegalArgumentException preloadNeededIfPersistenceIsEnabledForMetadataCache(final String indexName, final String cacheName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), preloadNeededIfPersistenceIsEnabledForMetadataCache$str(), indexName, cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String luceneStorageNoStateTransferEnabled = "ISPN015020: Lucene Directory for index '%s' can not use Cache '%s': fetch in state is not enabled in Cache configuration!";
    protected String luceneStorageNoStateTransferEnabled$str() {
        return luceneStorageNoStateTransferEnabled;
    }
    @Override
    public final IllegalArgumentException luceneStorageNoStateTransferEnabled(final String indexName, final String cacheName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), luceneStorageNoStateTransferEnabled$str(), indexName, cacheName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String affinityLocationIntoSegmentValueShallNotBeNegative = "ISPN015021: Lucene Directory for index '%s' can not set affinity location to segment id '%d': must be a positive integer!";
    protected String affinityLocationIntoSegmentValueShallNotBeNegative$str() {
        return affinityLocationIntoSegmentValueShallNotBeNegative;
    }
    @Override
    public final IllegalArgumentException affinityLocationIntoSegmentValueShallNotBeNegative(final String indexName, final int segmentId) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), affinityLocationIntoSegmentValueShallNotBeNegative$str(), indexName, segmentId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotStoreIndexOnAsyncCaches = "ISPN015022: Lucene Directory for index '%s' cannot use cache '%s' with mode '%s'. Only SYNC caches are supported!";
    protected String cannotStoreIndexOnAsyncCaches$str() {
        return cannotStoreIndexOnAsyncCaches;
    }
    @Override
    public final IllegalArgumentException cannotStoreIndexOnAsyncCaches(final String indexName, final String cacheName, final CacheMode used) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotStoreIndexOnAsyncCaches$str(), indexName, cacheName, used));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
