/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.impl.FileListCacheValue;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.lucene.testutils.TestSegmentReadLocker;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.DirectoryOnMultipleCachesTest")
public class DirectoryOnMultipleCachesTest
extends AbstractInfinispanTest {
    private static final long SLEEP = 60L;
    private static final int MAX_ITERATIONS = 1000;
    private EmbeddedCacheManager cacheManager;
    private Cache metadataCache;
    private Cache chunkCache;
    private Cache lockCache;

    @BeforeClass
    public void createBeforeClass() {
        this.cacheManager = CacheTestSupport.createLocalCacheManager();
        this.cacheManager.defineConfiguration("metadata", this.cacheManager.getDefaultCacheConfiguration());
        this.metadataCache = this.cacheManager.getCache("metadata");
        this.cacheManager.defineConfiguration("chunks", this.cacheManager.getDefaultCacheConfiguration());
        this.chunkCache = this.cacheManager.getCache("chunks");
        this.cacheManager.defineConfiguration("locks", this.cacheManager.getDefaultCacheConfiguration());
        this.lockCache = this.cacheManager.getCache("locks");
    }

    @Test
    public void testRunningOnMultipleCaches() throws IOException {
        assert (this.metadataCache != this.chunkCache);
        assert (this.chunkCache != this.lockCache);
        assert (this.lockCache != this.metadataCache);
        String indexName = "testingIndex";
        TestSegmentReadLocker testSegmentReadLocker = new TestSegmentReadLocker(this.lockCache, this.chunkCache, this.metadataCache, indexName);
        Directory dir = DirectoryBuilder.newDirectoryInstance((Cache)this.metadataCache, (Cache)this.chunkCache, (Cache)this.lockCache, (String)indexName).overrideSegmentReadLocker((SegmentReadLocker)testSegmentReadLocker).chunkSize(100).create();
        CacheTestSupport.writeTextToIndex(dir, 0, "hello world");
        CacheTestSupport.assertTextIsFoundInIds(dir, "hello", 0);
        CacheTestSupport.writeTextToIndex(dir, 1, "hello solar system");
        CacheTestSupport.assertTextIsFoundInIds(dir, "hello", 0, 1);
        CacheTestSupport.assertTextIsFoundInIds(dir, "system", 1);
        CacheTestSupport.optimizeIndex(dir);
        CacheTestSupport.assertTextIsFoundInIds(dir, "hello", 0, 1);
        dir.close();
    }

    @Test(dependsOnMethods={"testRunningOnMultipleCaches"})
    public void verifyIntendedChunkCachesUsage() {
        int chunks = 0;
        for (Object key : this.chunkCache.keySet()) {
            ++chunks;
            AssertJUnit.assertEquals(ChunkCacheKey.class, key.getClass());
            Object value = this.chunkCache.get(key);
            AssertJUnit.assertEquals(byte[].class, value.getClass());
        }
        assert (chunks != 0);
    }

    @Test(dependsOnMethods={"testRunningOnMultipleCaches"})
    public void verifyIntendedLockCachesUsage() {
        ArrayList keysThatShouldBeRemoved = new ArrayList();
        for (Object key : this.lockCache.keySet()) {
            AssertJUnit.assertEquals(FileReadLockKey.class, key.getClass());
            int value = (Integer)this.lockCache.get(key);
            if (value == 0) {
                keysThatShouldBeRemoved.add(key);
                continue;
            }
            AssertJUnit.assertEquals((int)1, (int)value);
        }
        for (int i = 0; i < 1000 && !keysThatShouldBeRemoved.isEmpty(); ++i) {
            try {
                Thread.sleep(60L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            Iterator iterator = keysThatShouldBeRemoved.iterator();
            while (iterator.hasNext()) {
                if (this.lockCache.containsKey(iterator.next())) continue;
                iterator.remove();
            }
        }
        AssertJUnit.assertTrue((String)("The following keys " + keysThatShouldBeRemoved + " are supposed to be removed from lockCache"), (boolean)keysThatShouldBeRemoved.isEmpty());
    }

    @Test(dependsOnMethods={"testRunningOnMultipleCaches"})
    public void verifyIntendedMetadataCachesUsage() {
        int metadata = 0;
        int filelists = 0;
        for (Object key : this.metadataCache.keySet()) {
            Object value = this.metadataCache.get(key);
            if (key.getClass().equals(FileListCacheKey.class)) {
                ++filelists;
                AssertJUnit.assertEquals(FileListCacheValue.class, value.getClass());
                continue;
            }
            if (key.getClass().equals(FileCacheKey.class)) {
                ++metadata;
                AssertJUnit.assertEquals(FileMetadata.class, value.getClass());
                continue;
            }
            AssertJUnit.fail((String)("unexpected type of key in metadata cache: " + key.getClass()));
        }
        AssertJUnit.assertEquals((int)1, (int)filelists);
        assert (metadata != 0);
    }

    @AfterClass
    public void afterClass() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
    }
}

