/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.configuration;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.configuration.NotIdleValidationTest")
public class NotIdleValidationTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = CacheTestSupport.createLocalCacheConfiguration();
        cfg.expiration().maxIdle(10L);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="ISPN(\\d)*: Lucene Directory for index 'testIndexBeta' can not use Cache 'NotIdleValidationTest': expiration idle time enabled on the Cache configuration!")
    public void failOnExpiry() {
        DirectoryBuilder.newDirectoryInstance((Cache)this.cache, (Cache)this.cache, (Cache)this.cache, (String)"testIndexBeta").create();
    }
}

