/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.lucene.impl.Operation;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ThreadSafe
@ProtoTypeId(value=4605)
public final class FileListCacheValue {
    private final Set<String> fileNames;
    private final Lock writeLock;
    private final Lock readLock;

    FileListCacheValue() {
        this(new HashSet<String>());
    }

    @ProtoFactory
    FileListCacheValue(Set<String> fileNames) {
        ReentrantReadWriteLock namesLock = new ReentrantReadWriteLock();
        this.fileNames = fileNames;
        this.writeLock = namesLock.writeLock();
        this.readLock = namesLock.readLock();
    }

    @ProtoField(number=1)
    Set<String> getFileNames() {
        this.readLock.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.fileNames);
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public FileListCacheValue(String[] listAll) {
        this();
        Collections.addAll(this.fileNames, listAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(List<Operation> operations) {
        this.writeLock.lock();
        try {
            for (Operation operation : operations) {
                operation.apply(this.fileNames);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean remove(String fileName) {
        this.writeLock.lock();
        try {
            boolean bl = this.fileNames.remove(fileName);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean add(String fileName) {
        this.writeLock.lock();
        try {
            boolean bl = this.fileNames.add(fileName);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAndRemove(String toAdd, String toRemove) {
        this.writeLock.lock();
        try {
            boolean doneAdd = this.fileNames.add(toAdd);
            boolean doneRemove = this.fileNames.remove(toRemove);
            boolean bl = doneAdd || doneRemove;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String[] toArray() {
        this.readLock.lock();
        try {
            String[] stringArray = this.fileNames.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean contains(String fileName) {
        this.readLock.lock();
        try {
            boolean bl = this.fileNames.contains(fileName);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.fileNames.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || FileListCacheValue.class != obj.getClass()) {
            return false;
        }
        FileListCacheValue other = (FileListCacheValue)obj;
        Set<String> copyFromOther = other.getFileNames();
        this.readLock.lock();
        try {
            boolean bl = this.fileNames.equals(copyFromOther);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        return "FileListCacheValue{fileNames=" + this.getFileNames() + "}";
    }
}

