/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.lucene.CacheTestSupport;
import org.infinispan.lucene.DirectoryIntegrityCheck;
import org.infinispan.lucene.SkipIndexingGuaranteed;
import org.infinispan.lucene.directory.DirectoryBuilder;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.lucene.testutils.TestSegmentReadLocker;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lucene.SimpleLuceneTest")
public class SimpleLuceneTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() {
        this.startClusterNode();
        this.startClusterNode();
    }

    private void startClusterNode() {
        ConfigurationBuilder configurationBuilder = CacheTestSupport.createTestConfiguration(TransactionMode.NON_TRANSACTIONAL);
        configurationBuilder.customInterceptors().addInterceptor().after(NonTransactionalLockingInterceptor.class).interceptor((AsyncInterceptor)new SkipIndexingGuaranteed());
        this.createClusteredCaches(1, "lucene", configurationBuilder);
    }

    @Test
    public void testIndexWritingAndFinding() throws IOException {
        String indexName = "indexName";
        Cache cache0 = this.cache(0, "lucene");
        Cache cache1 = this.cache(1, "lucene");
        TestSegmentReadLocker testSegmentReadLocker = new TestSegmentReadLocker(cache0, cache0, cache0, "indexName");
        Directory dirA = DirectoryBuilder.newDirectoryInstance((Cache)cache0, (Cache)cache0, (Cache)cache0, (String)"indexName").overrideSegmentReadLocker((SegmentReadLocker)testSegmentReadLocker).create();
        Directory dirB = DirectoryBuilder.newDirectoryInstance((Cache)cache1, (Cache)cache1, (Cache)cache1, (String)"indexName").overrideSegmentReadLocker((SegmentReadLocker)testSegmentReadLocker).create();
        CacheTestSupport.writeTextToIndex(dirA, 0, "hi from node A");
        CacheTestSupport.assertTextIsFoundInIds(dirA, "hi", 0);
        CacheTestSupport.assertTextIsFoundInIds(dirB, "hi", 0);
        CacheTestSupport.writeTextToIndex(dirB, 1, "hello node A, how are you?");
        CacheTestSupport.assertTextIsFoundInIds(dirA, "hello", 1);
        CacheTestSupport.assertTextIsFoundInIds(dirB, "hello", 1);
        CacheTestSupport.assertTextIsFoundInIds(dirA, "node", 1, 0);
        CacheTestSupport.assertTextIsFoundInIds(dirB, "node", 1, 0);
        CacheTestSupport.removeByTerm(dirA, "from");
        CacheTestSupport.assertTextIsFoundInIds(dirB, "node", 1);
        dirA.close();
        dirB.close();
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache0, "indexName");
        DirectoryIntegrityCheck.verifyDirectoryStructure(cache1, "indexName");
    }

    @Test(description="Verifies the caches can be reused after a Directory close")
    public void testCacheReuse() throws IOException {
        this.testIndexWritingAndFinding();
        this.cache(0, "lucene").getAdvancedCache().withFlags(Flag.SKIP_INDEXING).clear();
        this.testIndexWritingAndFinding();
    }
}

